package net.argius.stew.gui;

import java.awt.*;
import java.awt.event.*;
import java.text.*;

import javax.swing.*;

/**
 * eLXgplB
 */
final class TextSearchPanel extends JPanel {

    private JTextField text;
    private JCheckBox useRegexCheck;
    private JCheckBox ignoreCaseCheck;
    private TextSearch[] targets;
    private TextSearch target;

    /**
     * TextSearchPanel̐B
     * @param frame 
     * @param targets 
     */
    TextSearchPanel(JFrame frame, TextSearch[] targets) {
        this.targets = targets;
        setLayout(new FlowLayout());
        setVisible(false);
        final JTextField text = new JTextField(32);
        final JButton forward = new JButton(getMessage("forward"));
        final JButton backward = new JButton(getMessage("backward"));
        final JCheckBox useRegexCheck = new JCheckBox(getMessage("useregex"));
        final JCheckBox ignoreCaseCheck = new JCheckBox(getMessage("ignorecase"));
        final JButton close = new JButton(new ImageIcon(TextSearchPanel.class.getResource("icon.close.gif")));
        forward.setMargin(new Insets(0, 7, 0, 7));
        backward.setMargin(new Insets(0, 7, 0, 7));
        close.setMargin(new Insets(0, 0, 0, 0));
        close.setToolTipText(getMessage("close"));
        this.text = text;
        this.useRegexCheck = useRegexCheck;
        this.ignoreCaseCheck = ignoreCaseCheck;
        // layout
        add(close);
        add(new JLabel("     "));
        add(new JLabel(getMessage("label")));
        add(text);
        add(forward);
        add(backward);
        add(useRegexCheck);
        add(ignoreCaseCheck);
        // focus order
        final FocusTraversalPolicy parentPolicy = frame.getFocusTraversalPolicy();
        frame.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy() {

            public Component getComponentAfter(Container focusCycleRoot, Component component) {
                if (component == ignoreCaseCheck) {
                    return close;
                }
                return parentPolicy.getComponentAfter(focusCycleRoot, component);
            }

            public Component getComponentBefore(Container focusCycleRoot, Component component) {
                if (component == close) {
                    return ignoreCaseCheck;
                }
                return parentPolicy.getComponentBefore(focusCycleRoot, component);
            }

        });
        // binding events
        text.addKeyListener(new KeyAdapter() {

            public void keyPressed(KeyEvent e) {
                int c = e.getKeyCode();
                if (c == KeyEvent.VK_ENTER) {
                    if (text.getText().length() == 0) {
                        return;
                    }
                    startSearch(false);
                    requestFocus();
                    text.requestFocus();
                }
            }

        });
        forward.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                if (text.getText().length() == 0) {
                    return;
                }
                startSearch(false);
                requestFocus();
                forward.requestFocus();
            }

        });
        backward.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                if (text.getText().length() == 0) {
                    return;
                }
                startSearch(true);
                requestFocus();
                backward.requestFocus();
            }

        });
        close.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                setVisible(false);
            }

        });
        KeyAdapter esc = new KeyAdapter() {

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == KeyEvent.VK_ESCAPE) {
                    setVisible(false);
                }
            }

        };
        Component[] components = getComponents();
        for (int i = 0; i < components.length; i++) {
            Component c = components[i];
            Font font = c.getFont();
            c.setFont(font.deriveFont(font.getSize2D() * 0.8f));
            c.addKeyListener(esc);
        }
    }

    /**
     * bZ[W̎擾B
     * @param key bZ[WL[
     * @return bZ[W
     */
    private String getMessage(String key) {
        return Messages.getString("pane.TextSearchPane." + key);
    }

    /* (overridden)
     * @see javax.swing.JComponent#setVisible(boolean)
     */
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            text.requestFocus();
        } else {
            for (int i = 0; i < targets.length; i++) {
                targets[i].reset();
            }
            if (target != null && target instanceof Component) {
                Component c = (Component)target;
                c.requestFocus();
            }
        }
    }

    /**
     * target̐ݒB
     * @param target target
     */
    public void setTarget(TextSearch target) {
        this.target = target;
    }

    /**
     * eLXgJnB
     * @param backward tɌ邩ǂ
     */
    void startSearch(boolean backward) {
        String s = text.getText();
        boolean useRegularExpression = useRegexCheck.isSelected();
        boolean ignoreCase = ignoreCaseCheck.isSelected();
        TextSearchMatcher matcher = new TextSearchMatcher(s, useRegularExpression, ignoreCase);
        matcher.setBackward(backward);
        matcher.setContinuously(true);
        for (int i = 0; i < targets.length; i++) {
            targets[i].reset();
        }
        boolean found = target.search(matcher);
        if (!found) {
            String formatString = getMessage("message.notfound");
            String message = MessageFormat.format(formatString, new Object[]{s});
            Component parent;
            if (target instanceof Component) {
                parent = ((Component)target).getParent();
            } else {
                parent = getParent();
            }
            DialogMessage.alert(parent, message);
        }
    }

}