package net.argius.stew.gui;

import java.awt.*;
import java.util.regex.*;

import javax.swing.text.*;
import javax.swing.text.Highlighter.*;

/**
 * eLXg̈voB
 */
public final class TextSearchMatcher {

    private Pattern pattern;
    private String string;
    private boolean useRegularExpression;
    private boolean ignoreCase;
    private boolean backward;
    private boolean continuously;
    private int start;
    private int end;

    /**
     * TextSearchMatcher̐B
     * @param target Ώە܂̓p^[
     * @param useRegularExpression K\gp邩ǂ
     * @param ignoreCase 啶Ə̈Ⴂ𖳎邩ǂ
     */
    public TextSearchMatcher(String target, boolean useRegularExpression, boolean ignoreCase) {
        if (useRegularExpression) {
            int option = (ignoreCase) ? Pattern.CASE_INSENSITIVE : 0;
            this.pattern = Pattern.compile(target, option);
            this.string = target;
        } else if (ignoreCase) {
            this.string = target.toUpperCase();
        } else {
            this.string = target;
        }
        this.useRegularExpression = useRegularExpression;
        this.ignoreCase = ignoreCase;
    }

    /**
     * HighlightPainter̎擾B
     * @return HighlightPainter
     */
    public HighlightPainter getHighlightPainter() {
        return new DefaultHighlighter.DefaultHighlightPainter(Color.decode("#33dd66"));
    }

    /**
     * backward̎擾B
     * @return backward
     */
    public boolean isBackward() {
        return backward;
    }

    /**
     * backward̐ݒB
     * @param backward backward
     */
    public void setBackward(boolean backward) {
        this.backward = backward;
    }

    /**
     * continuously̎擾B
     * @return continuously
     */
    public boolean isContinuously() {
        return continuously;
    }

    /**
     * continuously̐ݒB
     * @param continuously continuously
     */
    public void setContinuously(boolean continuously) {
        this.continuously = continuously;
    }

    /**
     * B
     * @param value l
     * @return ꍇ <code>true</code>AłȂ <code>false</code>
     */
    public boolean find(String value) {
        return find(value, 0);
    }

    /**
     * B
     * @param value l
     * @param start Jnʒu
     * @return ꍇ <code>true</code>AłȂ <code>false</code>
     */
    public boolean find(String value, int start) {
        this.start = -1;
        this.end = -1;
        boolean found;
        if (useRegularExpression) {
            Matcher m = pattern.matcher(value);
            found = m.find(start);
            if (found) {
                this.start = m.start();
                this.end = m.end();
            }
        } else {
            String v = (ignoreCase) ? value.toUpperCase() : value;
            int index = v.indexOf(string, start);
            found = index >= start;
            if (found) {
                this.start = index;
                this.end = index + string.length();
            }
        }
        return found;
    }

    /**
     * start̎擾B
     * @return start
     */
    public int getStart() {
        return start;
    }

    /**
     * end̎擾B
     * @return end
     */
    public int getEnd() {
        return end;
    }

}
