package net.argius.stew.gui;

import java.io.*;
import java.util.*;

/**
 * ʃZbg̒l̔r֐B
 */
public final class ResultSetValueComparator implements Comparator, Serializable {

    /**
     * <code>serialVersionUID</code>
     */
    private static final long serialVersionUID = 5830826225563114971L;

    /* (overridden)
     * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
     */
    public int compare(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            if (o1 != null) {
                return 1;
            } else if (o2 != null) {
                return -1;
            } else {
                return 0;
            }
        }
        // except null
        if (o1 instanceof Number && o2 instanceof Number) {
            Number n1 = (Number)o1;
            Number n2 = (Number)o2;
            if (n1.equals(n2)) {
                return 0;
            } else {
                return (n1.doubleValue() > n2.doubleValue()) ? 1 : -1;
            }
        } else if (o1 instanceof Date && o2 instanceof Date) {
            Date d1 = (Date)o1;
            Date d2 = (Date)o2;
            return d1.compareTo(d2);
        } else if (o1 instanceof String && o2 instanceof String) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            return s1.compareTo(s2);
        } else {
            String s1 = o1.toString();
            String s2 = o2.toString();
            return s1.compareTo(s2);
        }
    }

}