package net.argius.stew.gui;

import java.awt.*;

import javax.swing.*;
import javax.swing.table.*;

/**
 * ResultSetTable̍sԍ\TableCellRendererB
 */
final class ResultSetTableRowNumberCellRenderer extends DefaultTableCellRenderer {

    /** Singleton */
    static final ResultSetTableRowNumberCellRenderer INSTANCE = new ResultSetTableRowNumberCellRenderer();

    private static final String INSERT_MARK = "*";

    /**
     * ResultSetTableRowNumberCellRenderer̐B
     */
    private ResultSetTableRowNumberCellRenderer() {
        // empty
    }

    /* (overridden)
     * @see javax.swing.table.DefaultTableCellRenderer#getTableCellRendererComponent(javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
     */
    public Component getTableCellRendererComponent(JTable table,
                                                   Object value,
                                                   boolean isSelected,
                                                   boolean hasFocus,
                                                   int row,
                                                   int column) {
        JLabel label;
        if (INSERT_MARK.equals(value)) {
            label = new JLabel(INSERT_MARK);
            label.setHorizontalAlignment(CENTER);
        } else {
            label = new JLabel(String.valueOf(row + 1) + ' ');
            label.setHorizontalAlignment(RIGHT);
        }
        label.setFont(table.getFont());
        label.setOpaque(true);
        return label;
    }

}