package net.argius.stew.gui;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.sql.*;
import java.util.*;
import java.util.List;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;

import net.argius.logging.*;
import net.argius.stew.*;
import net.argius.stew.io.*;

/**
 * ʃZbgp̃e[uB
 */
class ResultSetTable extends JTable implements TextSearch {

    private static final Logger log = LoggerFactory.getLogger(ResultSetTable.class);

    private final Environment env;
    private final ResultSetTableHeaderCellRenderer headerRenderer;
    private final ResultSetTableRowHeader rowHeader;

    private int limitCount;
    private boolean[] sortedAscArray;
    private String columnAdjustMode;
    private int dragStartColumn;

    /*
     * ZҏWJneditCellAt(int, int, EventObject)Ă΂ꂽꍇA
     * KeyEventߑłȂ߁AOKeyEventۑĎgB
     */
    private volatile KeyEvent lastKeyEvent;

    /**
     * ResultSetTable̐B
     * @param env s
     */
    ResultSetTable(Environment env) {
        this.env = env;
        this.headerRenderer = new ResultSetTableHeaderCellRenderer(getTableHeader().getDefaultRenderer());
        this.rowHeader = new ResultSetTableRowHeader(this);
        this.limitCount = Integer.MAX_VALUE;
        this.sortedAscArray = new boolean[0];
        initialize();
    }

    /**
     * ő\̎擾B
     * @return limitCount ő\
     */
    int getLimitCount() {
        return limitCount;
    }

    /**
     * ő\̐ݒB
     * @param limitCount ő\
     */
    public void setLimitCount(int limitCount) {
        this.limitCount = limitCount;
    }

    /**
     * 񕝒[h̎擾B
     * @return 񕝒[h
     */
    String getColumnAdjustMode() {
        return columnAdjustMode;
    }

    /**
     * 񕝒[h̐ݒB
     * @param columnAdjustMode 񕝒[h
     */
    void setColumnAdjustMode(String columnAdjustMode) {
        this.columnAdjustMode = columnAdjustMode;
    }

    /**
     * B
     */
    private void initialize() {
        ResultSetTableAction.bindAction(this);
        getTableHeader().setDefaultRenderer(headerRenderer);
        JTableHeader header = getTableHeader();
        header.setReorderingAllowed(false);
        ContextMenu contextMenu = new ContextMenu(this);
        addMouseListener(contextMenu);
        header.addMouseListener(contextMenu);
        header.addMouseListener(new MouseAdapter() {

            /* (overridden)
             * @see java.awt.event.MouseAdapter#mousePressed(java.awt.event.MouseEvent)
             */
            public void mousePressed(MouseEvent e) {
                onTableHeaderClicked(e);
            }

        });
        header.addMouseMotionListener(new MouseMotionAdapter() {

            /* (overridden)
             * @see java.awt.event.MouseMotionAdapter#mouseDragged(java.awt.event.MouseEvent)
             */
            public void mouseDragged(MouseEvent e) {
                onTableHeaderClicked(e);
            }

        });
        addKeyListener(new KeyListener() {

            public void keyTyped(KeyEvent e) {
                setLastKeyEvent(e);
            }

            public void keyReleased(KeyEvent e) {
                setLastKeyEvent(e);
            }

            public void keyPressed(KeyEvent e) {
                setLastKeyEvent(e);
            }

        });
    }

    /**
     * lastKeyEvent̐ݒB
     * @param lastKeyEvent lastKeyEvent
     */
    void setLastKeyEvent(KeyEvent lastKeyEvent) {
        this.lastKeyEvent = lastKeyEvent;
    }

    /* (overridden)
     * @see javax.swing.JComponent#setFont(java.awt.Font)
     */
    public void setFont(Font font) {
        super.setFont(font);
        double rate = getSizeRate(font);
        setRowHeight((int)(16 * rate));
        //
        TableColumnModel columnModel = getColumnModel();
        if (columnModel != null && columnModel.getColumnCount() > 0) {
            getTableHeader().setFont(font);
            TableColumn column0 = columnModel.getColumn(0);
            double sizeRate = getSizeRate(getFont()) * 10;
            column0.setPreferredWidth((int)(4 * sizeRate));
        }
    }

    /* (overridden)
     * @see javax.swing.JTable#configureEnclosingScrollPane()
     */
    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
        Container p = getParent();
        if (p instanceof JViewport) {
            Container gp = p.getParent();
            if (gp instanceof JScrollPane) {
                JScrollPane scrollPane = (JScrollPane)gp;
                JViewport viewport = scrollPane.getViewport();
                if (viewport == null || viewport.getView() != this) {
                    return;
                }
                scrollPane.setRowHeaderView(rowHeader);
            }
        }
    }

    /* (overridden)
     * @see javax.swing.JTable#editingStopped(javax.swing.event.ChangeEvent)
     */
    public void editingStopped(ChangeEvent e) {
        Object source = e.getSource();
        if (source instanceof CellEditor) {
            CellEditor editor = (CellEditor)source;
            ResultSetTableModel model = (ResultSetTableModel)getModel();
            if (!model.isInsertRow(getEditingRow())) {
                model.updateCellEdited(this, editor);
            }
            validate();
        }
        super.editingStopped(e);
    }

    /* (overridden)
     * @see javax.swing.JTable#getCellEditor()
     */
    public TableCellEditor getCellEditor() {
        TableCellEditor cellEditor = super.getCellEditor();
        if (cellEditor instanceof DefaultCellEditor) {
            DefaultCellEditor d = (DefaultCellEditor)cellEditor;
            Component component = d.getComponent();
            if (component != null) {
                if (!component.isEnabled()) {
                    log.warn("forced to enable CellEditor");
                    component.setEnabled(true);
                }
                component.setFont(getFont());
                component.setBackground(Color.PINK);
            }
        }
        return cellEditor;
    }

    /* (overridden)
     * @see javax.swing.JTable#getCellRenderer(int, int)
     */
    public TableCellRenderer getCellRenderer(int row, int column) {
        if (getValueAt(row, column) != null) {
            return super.getCellRenderer(row, column);
        } else {
            return ResultSetTableNullValueCellRenderer.INSTANCE;
        }
    }

    /* (overridden)
     * @see javax.swing.JTable#editCellAt(int, int, java.util.EventObject)
     */
    public boolean editCellAt(int row, int column, EventObject e) {
        boolean succeeded = super.editCellAt(row, column, e);
        if (succeeded) {
            if (editorComp instanceof JTextField) {
                // #208: ZҏW[hŒlIԂɂ
                if (lastKeyEvent != null && lastKeyEvent.getKeyCode() != KeyEvent.VK_F2) {
                    JTextField editor = (JTextField)editorComp;
                    editor.selectAll();
                }
            }
        }
        return succeeded;
    }

    /* (overridden)
     * @see net.argius.stew.gui.TextSearch#search(net.argius.stew.gui.TextSearchMatcher)
     */
    public boolean search(TextSearchMatcher matcher) {
        final int rowCount = getRowCount();
        if (rowCount <= 0) {
            return false;
        }
        final int columnCount = getColumnCount();
        final boolean backward = matcher.isBackward();
        final int amount = backward ? -1 : 1;
        final int rowStart = backward ? rowCount - 1 : 0;
        final int rowEnd = backward ? 0 : rowCount - 1;
        final int columnStart = backward ? columnCount - 1 : 0;
        final int columnEnd = backward ? 0 : columnCount - 1;
        int row = rowStart;
        int column = columnStart;
        if (getSelectedColumnCount() > 0) {
            column = getSelectedColumn();
            row = getSelectedRow() + amount;
            if (backward) {
                if (row < 0) {
                    --column;
                    if (column < 0) {
                        return false;
                    }
                    row = rowStart;
                }
            } else {
                if (row >= rowCount) {
                    ++column;
                    if (column >= columnCount) {
                        return false;
                    }
                    row = rowStart;
                }
            }
        }
        for (; backward ? column >= columnEnd : column <= columnEnd; column += amount) {
            for (; backward ? row >= rowEnd : row <= rowEnd; row += amount) {
                if (matcher.find(String.valueOf(getValueAt(row, column)))) {
                    changeSelection(row, column, false, false);
                    requestFocus();
                    return true;
                }
            }
            row = rowStart;
        }
        return false;
    }

    /* (overridden)
     * @see net.argius.stew.gui.TextSearch#reset()
     */
    public void reset() {
        // empty
    }

    /**
     * TCY{̎擾B
     * @param font ƂȂtHg
     * @return TCY{
     */
    private double getSizeRate(Font font) {
        return font.getSize() / 1d / FormedFont.Regular.getSize();
    }

    /**
     * ԍ\Ԃ̎擾B
     * @return ԍ\
     */
    boolean isShowColumnNumber() {
        return headerRenderer.isShowNumber();
    }

    /**
     * ԍ\Ԃ̐ݒB
     * @param isShowColumnNumber ԍ\
     */
    void setShowColumnNumber(boolean isShowColumnNumber) {
        headerRenderer.setShowNumber(isShowColumnNumber);
    }

    /**
     * e[uwb_}EXNbNꂽ̃CxgB
     * @param e }EXCxg
     */
    final void onTableHeaderClicked(MouseEvent e) {
        if (getRowCount() == 0) {
            return;
        }
        Point p = new Point(e.getX(), e.getY());
        if (SwingUtilities.isLeftMouseButton(e)) {
            int id = e.getID();
            boolean isMousePressed = id == MouseEvent.MOUSE_PRESSED;
            boolean isMouseDragged = id == MouseEvent.MOUSE_DRAGGED;
            if (isMousePressed || isMouseDragged) {
                if (!e.isControlDown() && !e.isShiftDown()) {
                    clearSelection();
                }
                int columnIndex = columnAtPoint(p);
                if (columnIndex < 0 || getColumnCount() <= columnIndex) {
                    return;
                }
                int index0;
                int index1;
                if (isMousePressed) {
                    if (e.isShiftDown()) {
                        index0 = dragStartColumn;
                        index1 = columnIndex;
                    } else {
                        dragStartColumn = columnIndex;
                        index0 = columnIndex;
                        index1 = columnIndex;
                    }
                } else if (isMouseDragged) {
                    index0 = dragStartColumn;
                    index1 = columnIndex;
                } else {
                    return;
                }
                selectColumn(index0, index1);
                requestFocus();
            }
        }
    }

    /**
     * IB
     * @param columnIndex CfbNX
     * @deprecated selectColumn(int, int) gpĂB
     */
    void selectColumn(int columnIndex) {
        selectColumn(columnIndex, columnIndex);
    }

    /**
     * IB
     * @param index0 JnCfbNX
     * @param index1 ICfbNX
     */
    void selectColumn(int index0, int index1) {
        if (getRowCount() > 0) {
            addColumnSelectionInterval(index0, index1);
            addRowSelectionInterval(getRowCount() - 1, 0);
        }
    }

    /**
     * 0(ō)̕B
     * @deprecated sԍ\ ResultSetTableRowHeader ɒu܂B̃\bh͉܂B
     */
    void fitColumn0() {
        // do nothing
    }

    /**
     * e[u}EXNbNꂽ̃CxgB
     * @param e }EXCxg
     * @deprecated sԍ\ ResultSetTableRowHeader ɒu܂B̃\bh͉܂B
     */
    final void onTableClicked(MouseEvent e) {
        // do nothing
    }

    /**
     * \[gs˗B
     * @param selectedIndex Iꂽ
     */
    void requestSort(int selectedIndex) {
        if (selectedIndex > 0) {
            final int threshold = 100000;
            if (getRowCount() > threshold) {
                final String message = Messages.getString("window.ResultSetTable.sort.confirm");
                int result = DialogMessage.confirmYesNo(getParent(), message);
                if (result != JOptionPane.OK_OPTION) {
                    return;
                }
            }
        }
        sort(selectedIndex);
    }

    /**
     * \[gB
     * @param index Iꂽ
     */
    private void sort(final int index) {
        final boolean sortedAsc = sortedAscArray[index];
        final Comparator cmp = new ResultSetValueComparator();
        final int flip = sortedAsc ? -1 : 1;
        Collections.sort(((DefaultTableModel)getModel()).getDataVector(), new Comparator() {

            public int compare(Object o1, Object o2) {
                List a1 = (List)o1;
                List a2 = (List)o2;
                return cmp.compare(a1.get(index), a2.get(index)) * flip;
            }

        });
        for (int i = 0; i < sortedAscArray.length; i++) {
            sortedAscArray[i] = index == i && !sortedAsc;
        }
        repaint();
    }

    /**
     * 񕝂ύXB
     * @param rate {
     */
    void changeColumnWidth(double rate) {
        TableColumnModel columnModel = getColumnModel();
        for (int i = 0, n = getColumnCount(); i < n; i++) {
            TableColumn column = columnModel.getColumn(i);
            int newWidth = (int)(column.getWidth() * rate);
            column.setPreferredWidth(newWidth);
        }
    }

    /**
     * 񕝂̎sB
     */
    void adjustColumnWidth() {
        if (columnAdjustMode == null) {
            return;
        }
        final boolean byHeader;
        final boolean byValue;
        if (columnAdjustMode.equalsIgnoreCase("header")) {
            byHeader = true;
            byValue = false;
        } else if (columnAdjustMode.equalsIgnoreCase("value")) {
            byHeader = false;
            byValue = true;
        } else if (columnAdjustMode.equalsIgnoreCase("header-and-value")) {
            byHeader = true;
            byValue = true;
        } else {
            byHeader = false;
            byValue = false;
        }
        int rowCount = getRowCount();
        if (!byHeader && byValue && rowCount == 0) {
            return;
        }
        final float max = getParent().getWidth() * 0.8f;
        TableColumnModel columnModel = getColumnModel();
        JTableHeader header = getTableHeader();
        for (int columnIndex = 0, n = getColumnCount(); columnIndex < n; columnIndex++) {
            float size = 0f;
            if (byHeader) {
                // wb_̕ɂ钲
                TableColumn column = columnModel.getColumn(columnIndex);
                TableCellRenderer renderer = column.getHeaderRenderer();
                if (renderer == null) {
                    renderer = header.getDefaultRenderer();
                }
                if (renderer != null) {
                    Component c = renderer.getTableCellRendererComponent(this,
                                                                         column.getHeaderValue(),
                                                                         false,
                                                                         false,
                                                                         0,
                                                                         columnIndex);
                    size = c.getPreferredSize().width * 1.5f;
                }
            }
            if (byValue) {
                // l̕ɂ钲
                for (int rowIndex = 0; rowIndex < rowCount; rowIndex++) {
                    TableCellRenderer renderer = getCellRenderer(rowIndex, columnIndex);
                    if (renderer == null) {
                        continue;
                    }
                    String value = String.valueOf(getValueAt(rowIndex, columnIndex));
                    Component c = renderer.getTableCellRendererComponent(this,
                                                                         value,
                                                                         false,
                                                                         false,
                                                                         rowIndex,
                                                                         columnIndex);
                    size = Math.max(size, c.getPreferredSize().width);
                    if (size >= max) {
                        break;
                    }
                }
            }
            int width = Math.round(size > max ? max : size) + 1;
            columnModel.getColumn(columnIndex).setPreferredWidth(width);
        }
    }

    /**
     * et@Cɏo͂B
     * @param file t@C
     * @throws IOException o̓G[ꍇ
     */
    void export(File file) throws IOException {
        Exporter exporter = Exporter.getExporter(file);
        try {
            int columnCount = getColumnCount();
            int rowCount = getRowCount();
            DefaultTableModel model = (DefaultTableModel)getModel();
            List data = model.getDataVector();
            for (int rowIndex = 0; rowIndex < rowCount; rowIndex++) {
                List row = (List)data.get(rowIndex);
                exporter.addRow(row.subList(1, columnCount).toArray());
            }
        } finally {
            exporter.close();
        }
    }

    /**
     * ʃZbgo͂B
     * @param rs ʃZbg
     * @param order 
     * @param cmd R}h
     * @return ʂ̌
     * @throws SQLException SQL֘AG[ꍇ
     */
    int outputResultSet(ResultSet rs, ColumnOrder order, String cmd) throws SQLException {

        /*
         * ͔̏AWTXbhs邽
         * GUȈEventDispatchThreadsĂ
         */

        // \̍XV(O)
        final JTableHeader header = this.tableHeader;
        final DefaultTableModel rowHeaderModel = (DefaultTableModel)rowHeader.getModel();
        EventQueue.invokeLater(new Runnable() {

            public void run() {
                setVisible(false);
                header.setVisible(false);
                rowHeaderModel.setRowCount(0);
            }

        });

        // f[^f
        boolean needOrderChange = order.size() > 0;
        ResultSetMetaData rsmeta = rs.getMetaData();
        int cols;
        int[] types;
        if (needOrderChange) {
            cols = order.size();
            types = new int[cols];
            for (int i = 0; i < cols; i++) {
                int index = order.getOrder(i);
                types[i] = rsmeta.getColumnType(index);
            }
        } else {
            cols = order.size();
            cols = rsmeta.getColumnCount();
            types = new int[cols];
            for (int i = 0; i < cols; i++) {
                types[i] = rsmeta.getColumnType(i + 1);
            }
        }
        ResultSetTableMonitor monitor = new ResultSetTableMonitor();
        final ResultSetTableModel model = new ResultSetTableModel(cols, types, monitor, rowHeader);

        // [vJn
        int rowCount = 0;
        for (; rs.next(); rowCount++) {
            if (rowCount >= limitCount) {
                break;
            }
            Vector row = new Vector();
            for (int i = 0; i < cols; i++) {
                int index;
                if (needOrderChange) {
                    index = order.getOrder(i);
                } else {
                    index = i + 1;
                }
                row.add(rs.getObject(index));
            }
            model.addRow(row);
        }

        // wb_\l
        final String[] headerValues = new String[cols];
        for (int i = 0; i < cols; i++) {
            String columnName;
            if (needOrderChange) {
                columnName = order.getName(i);
            } else {
                columnName = rsmeta.getColumnName(i + 1);
            }
            headerValues[i] = columnName;
        }

        // I
        sortedAscArray = new boolean[cols];
        if (!env.getCurrentConnector().isReadOnly()) {
            monitor.prepare(rs, cmd);
        }

        // \̍XV()
        EventQueue.invokeLater(new Runnable() {

            public void run() {
                setModel(model);
                int columnCount = getColumnCount();
                TableColumnModel columnModel = getColumnModel();
                for (int i = 0; i < columnCount; i++) {
                    TableColumn column = columnModel.getColumn(i);
                    column.setHeaderValue(headerValues[i]);
                }
                adjustColumnWidth();
                model.addTableModelListener(ResultSetTable.this);
                setUpdatableSign();
                validate();
                header.setVisible(true);
                setVisible(true);
            }

            /**
             * XVۃTC̐ݒB
             */
            private void setUpdatableSign() {
                Container p = getParent();
                if (p != null && p.getParent() instanceof JScrollPane) {
                    JScrollPane scrollPane = (JScrollPane)p.getParent();
                    String iconResource = "icon.updatable." + model.isUpdatable() + ".gif";
                    scrollPane.setCorner(ScrollPaneConstants.UPPER_LEFT_CORNER,
                                         new JLabel(new ImageIcon(getClass().getResource(iconResource)),
                                                    SwingConstants.CENTER));
                }
            }

        });

        return rowCount;
    }

}