package net.argius.stew.gui;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;

import net.argius.logging.*;

/**
 * _ȃ_CAO̓yB
 */
public abstract class FlexibleDialogBase extends JDialog {

    private static final Logger log = LoggerFactory.getLogger(FlexibleDialogBase.class);

    protected GridBagLayout g;
    protected GridBagConstraints c;

    /**
     * FlexibleDialogBase̐B
     * @param owner
     * @throws HeadlessException
     */
    protected FlexibleDialogBase(Frame owner) throws HeadlessException {
        super(owner);
        initialize();
    }

    /**
     * FlexibleDialogBase̐B
     * @param owner
     * @throws HeadlessException
     */
    protected FlexibleDialogBase(Dialog owner) throws HeadlessException {
        super(owner);
        initialize();
    }

    /**
     * B
     */
    private void initialize() {
        setResizable(false);
        initializeKeyBind(this);
        g = new GridBagLayout();
        getContentPane().setLayout(g);
        c = new GridBagConstraints();
        c.gridwidth = 8;
        c.fill = GridBagConstraints.NONE;
        c.ipadx = 2;
        c.ipady = 0;
        c.insets = new Insets(2, 4, 2, 4);
        c.anchor = GridBagConstraints.WEST;
        c.weightx = 1.0;
        c.weighty = 1.0;
    }

    /**
     * R|[lg̔zuB
     * @param component R|[lg
     * @param isRowEnd s̏IȂ <code>true</code> w
     */
    protected void addComponent(Component component, boolean isRowEnd) {
        if (component instanceof JTextField) {
            component.setFont(FormedFont.Large);
        }
        initializeKeyBind(component);
        if (isRowEnd) {
            c.gridwidth = GridBagConstraints.REMAINDER;
        }
        g.setConstraints(component, c);
        getContentPane().add(component);
        if (isRowEnd) {
            c.gridwidth = GridBagConstraints.LINE_START;
        }
    }

    /**
     * JButton̐B
     * @param caption 
     * @param action ANV
     * @return JButton
     */
    protected JButton createJButton(String caption, ActionListener action) {
        JButton button = new JButton(caption);
        if (action != null) {
            button.addActionListener(action);
        }
        return button;
    }

    /**
     * L[oCh̏B
     * @param component R|[lg
     */
    protected final void initializeKeyBind(Component component) {
        component.addKeyListener(new KeyAdapter() {

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == KeyEvent.VK_ESCAPE) {
                    dispose();
                }
            }

        });
    }

    /**
     * G[̏B
     * @param th O
     */
    protected final void onError(Throwable th) {
        log.error("", th);
        DialogMessage.alert(this, th.getMessage());
    }

}