package net.argius.stew.gui;

import java.awt.*;
import java.awt.datatransfer.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.table.*;
import javax.swing.text.*;

import net.argius.logging.*;

/**
 * ReLXgj[B
 */
final class ContextMenu extends MouseAdapter {

    private static final Logger log = LoggerFactory.getLogger(ContextMenu.class);

    private final Component parent;

    /**
     * ContextMenu̐B
     * @param parent
     */
    ContextMenu(Component parent) {
        this.parent = parent;
    }

    /* (overridden)
     * @see java.awt.event.MouseAdapter#mouseClicked(java.awt.event.MouseEvent)
     */
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            Object source = e.getSource();
            if (parent instanceof ResultSetTable) {
                showMenuForResultSetTable(e);
            } else if (source instanceof JTextComponent) {
                showMenuForJTextComponent((JTextComponent)source, e);
            }
        }
    }

    /**
     * ResultSetTablẽj[\B
     * @param e }EXCxg
     */
    private void showMenuForResultSetTable(MouseEvent e) {
        final ResultSetTable table = (ResultSetTable)parent;
        final ResultSetTableModel model = (ResultSetTableModel)table.getModel();
        final Object source = e.getSource();
        final int x = e.getX();
        final int y = e.getY();
        final int selectedColumn = table.getSelectedColumn();
        final int selectedRow = table.getSelectedRow();
        final int clickedColumn = table.columnAtPoint(e.getPoint());
        final boolean isUpdatable = model.isUpdatable();
        final boolean isCellSelected = selectedColumn >= 0;
        final boolean isCellEditable = model.isCellEditable(selectedRow, selectedColumn);
        final boolean isSelectedInsertRow = model.isInsertRow(selectedRow);
        final boolean isClipboardEnabled = isClipboardEnabled();
        final boolean isTable = source instanceof ResultSetTable;
        final boolean isColumnHeader = source instanceof JTableHeader;
        final boolean isRowHeader = source instanceof ResultSetTableRowHeader;
        JPopupMenu popup = new JPopupMenu();
        if (isColumnHeader) {
            popup.add(createJMenuItem(getMessage("header.sort"), 'S', new AbstractAction() {

                public void actionPerformed(ActionEvent e) {
                    table.requestSort(clickedColumn);
                }

            }));
            popup.add(createJMenuItem(getMessage("header.selectcolumn"), 'C', new AbstractAction() {

                public void actionPerformed(ActionEvent e) {
                    Point p = new Point(x, y);
                    int index = table.getTableHeader().columnAtPoint(p);
                    table.selectColumn(index, index);
                }

            }));
            popup.add(new JPopupMenu.Separator());
        }
        if (isRowHeader) {
            popup.add(createJMenuItem(getMessage("header.selectrow"), 'R', new AbstractAction() {

                public void actionPerformed(ActionEvent e) {
                    int index = table.rowAtPoint(new Point(x, y));
                    table.addRowSelectionInterval(index, index);
                    table.addColumnSelectionInterval(table.getColumnCount() - 1, 0);
                }

            }));
            popup.add(new JPopupMenu.Separator());
        }
        popup.add(createJMenuItem(table, "table.copy.cell", 'C', "copy"))
             .setEnabled(isCellSelected);
        popup.add(createJMenuItem(table,
                                  "table.copy.cell.withescape",
                                  'E',
                                  ResultSetTableAction.COPY_CELL_WITH_ESCAPE))
             .setEnabled(isCellSelected);
        popup.add(createJMenuItem(table,
                                  "table.paste.cell",
                                  'P',
                                  ResultSetTableAction.PASTE_TO_SELECTED_CELLS))
             .setEnabled(isCellEditable);
        popup.add(createJMenuItem(table,
                                  "table.copy.columnnames",
                                  'Y',
                                  ResultSetTableAction.COPY_COLUMN_NAMES));
        popup.add(createJMenuItem(table,
                                  "table.null.value",
                                  'V',
                                  ResultSetTableAction.SET_NULL_TO_SELECTED_CELLS))
             .setEnabled(isCellEditable);
        popup.add(createJMenuItem(table, "table.select.all", 'S', "selectAll"));
        popup.add(new JPopupMenu.Separator());
        popup.add(createJMenuItem(table, "table.add.newrow", 'N', ResultSetTableAction.ADD_NEW_ROW))
             .setEnabled(isCellEditable);
        popup.add(createJMenuItem(table,
                                  "table.insert.paste",
                                  'O',
                                  ResultSetTableAction.INSERT_FROM_CLIPBOARD))
             .setEnabled(isUpdatable && isClipboardEnabled && !isSelectedInsertRow);
        if (isTable || isRowHeader) {
            popup.add(createJMenuItem(table,
                                      "table.add.duplicatedrow",
                                      'A',
                                      ResultSetTableAction.ADD_DUPLICATE_ROW))
                 .setEnabled(isCellEditable && !isSelectedInsertRow);
            popup.add(createJMenuItem(table,
                                      "table.fix.insert",
                                      'F',
                                      ResultSetTableAction.INSERT_ADDED_ROWS))
                 .setEnabled(isCellEditable && isSelectedInsertRow);
            popup.add(createJMenuItem(table,
                                      "table.delete.row",
                                      'D',
                                      ResultSetTableAction.DELETE_SELECTED_ROWS))
                 .setEnabled(isCellEditable);
        }
        popup.show(table, x, y);
    }

    /**
     * JTextComponentp̃ReLXgj[\B
     * @param component KpΏۂ̃R|[lg
     * @param e }EXCxg
     */
    private void showMenuForJTextComponent(JComponent component, MouseEvent e) {
        boolean isClipboardEnabled = isClipboardEnabled();
        JPopupMenu popup = new JPopupMenu();
        popup.add(createJMenuItem(component, "text.cut", 'T', "cut-to-clipboard"));
        popup.add(createJMenuItem(component, "text.copy", 'C', "copy-to-clipboard"));
        popup.add(createJMenuItem(component, "text.paste", 'P', "paste-from-clipboard"))
             .setEnabled(isClipboardEnabled);
        popup.show(component, e.getX(), e.getY());
    }

    /**
     * JMenuItem̐B
     * @param component ΏۃR|[lg
     * @param messageKey bZ[WL[
     * @param mnemonic 蓖ĕ
     * @param actionKey ANVL[IuWFNg
     * @return JMenuItem
     */
    private static JMenuItem createJMenuItem(JComponent component,
                                             String messageKey,
                                             char mnemonic,
                                             Object actionKey) {
        final String key = String.valueOf(actionKey);
        final Action action = component.getActionMap().get(key);
        if (action == null) {
            throw new IllegalStateException("action not found: " + key);
        }
        final Object src = component;
        Action delegate = new AbstractAction() {

            public void actionPerformed(ActionEvent e) {
                action.actionPerformed(new ActionEvent(src, ActionEvent.ACTION_PERFORMED, key));
            }

        };
        JMenuItem item = createJMenuItem(getMessage(messageKey), mnemonic, delegate);
        if (messageKey.equals("table.copy.cell") || messageKey.equals("text.copy")) {
            item.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_C, InputEvent.CTRL_DOWN_MASK));
        } else {
            final boolean isText = messageKey.startsWith("text.");
            InputMap imap = component.getInputMap();
            KeyStroke[] keys = imap.allKeys();
            if (keys != null) {
                String candity = "?";
                for (int i = 0; i < keys.length; i++) {
                    KeyStroke keyStroke = keys[i];
                    String keyName = String.valueOf(imap.get(keyStroke));
                    if (keyName.equals(actionKey) && candity.compareTo(keyName) < 0) {
                        if (isText) {
                            if (keyStroke.toString().matches("ctrl pressed [A-Z]")) {
                                item.setAccelerator(keyStroke);
                                break;
                            }
                        } else {
                            candity = keyName;
                            item.setAccelerator(keyStroke);
                        }
                    }
                }
            }
        }
        return item;
    }

    /**
     * JMenuItem̐B
     * @param caption \
     * @param mnemonic 蓖ĕ
     * @param action ANV
     * @return JMenuItem
     */
    private static JMenuItem createJMenuItem(String caption, char mnemonic, Action action) {
        JMenuItem item = new JMenuItem(caption, mnemonic);
        if (action != null) {
            item.addActionListener(action);
        }
        return item;
    }

    /**
     * Nbv{[hp\ǂ𒲍B
     * Nbv{[hef[^Ƃ݂Ȃꂽꍇɗp\ƂB
     * @return Nbv{[hp\Ȃ<code>true</code>AłȂ<code>false</code>
     */
    private static boolean isClipboardEnabled() {
        return Toolkit.getDefaultToolkit()
                      .getSystemClipboard()
                      .getContents(null)
                      .isDataFlavorSupported(DataFlavor.stringFlavor);
    }

    /**
     * j["ZRs["IꂽƂ̏B
     * @param table e[u
     * @deprecated ResultSetTableAction ResultSetTableAction ɒu܂B̃\bh͉܂B
     */
    void onMenuCopySelectedCellValueSelected(JTable table) {
        // do nothing
    }

    /**
     * j["Z\t"IꂽƂ̏B
     * @param table e[u
     * @deprecated ResultSetTableAction ResultSetTableAction ɒu܂B̃\bh͉܂B
     */
    void onMenuPasteValueToSelectedCellSelected(JTable table) {
        // do nothing
    }

    /**
     * j["ׂđI"IꂽƂ̏B
     * @param table e[u
     * @deprecated ResultSetTableAction ResultSetTableAction ɒu܂B̃\bh͉܂B
     */
    void onMenuSelectAllSelected(JTable table) {
        // do nothing
    }

    /**
     * j["Null̐ݒ"IꂽƂ̏B
     * @param table e[u
     * @deprecated ResultSetTableAction ResultSetTableAction ɒu܂B̃\bh͉܂B
     */
    void onMenuResetValueSelected(JTable table) {
        // do nothing
    }

    /**
     * j["VKs}"IꂽƂ̏B
     * @param table e[u
     * @deprecated ResultSetTableAction ResultSetTableAction ɒu܂B̃\bh͉܂B
     */
    void onMenuAddNewRowSelected(JTable table) {
        // do nothing
    }

    /**
     * j["Rs[}"IꂽƂ̏B
     * @param table e[u
     * @deprecated ResultSetTableAction ResultSetTableAction ɒu܂B̃\bh͉܂B
     */
    void onMenuCopyInsertRowSelected(JTable table) {
        // do nothing
    }

    /**
     * j["Nbv{[h}"IꂽƂ̏B
     * @param table e[u
     * @deprecated ResultSetTableAction ResultSetTableAction ɒu܂B̃\bh͉܂B
     */
    void onMenuInsertClipboardDataelected(JTable table) {
        // do nothing
    }

    /**
     * j["}m"IꂽƂ̏B
     * @param table e[u
     * @deprecated ResultSetTableAction ResultSetTableAction ɒu܂B̃\bh͉܂B
     */
    void onMenuFixInsertSelected(JTable table) {
        // do nothing
    }

    /**
     * j["s폜"IꂽƂ̏B
     * @param table e[u
     * @deprecated ResultSetTableAction ResultSetTableAction ɒu܂B̃\bh͉܂B
     */
    void onMenuDeleteRowSelected(JTable table) {
        // do nothing
    }

    /**
     * j["\[g"IꂽƂ̏B
     * @param table e[u
     * @param columnIndex I
     * @deprecated ResultSetTableAction ResultSetTableAction ɒu܂B̃\bh͉܂B
     */
    void onMenuSortColumnSelected(JTable table, int columnIndex) {
        // do nothing
    }

    /**
     * j["I"IꂽƂ̏B
     * @param table e[u
     * @param columnIndex I
     * @deprecated ResultSetTableAction ResultSetTableAction ɒu܂B̃\bh͉܂B
     */
    void onMenuSelectColumnSelected(JTable table, int columnIndex) {
        // do nothing
    }

    /**
     * G[̏B
     * @param th O
     */
    void onError(Throwable th) {
        log.error("", th);
        DialogMessage.alert(parent, th.getMessage());
    }

    /**
     * (O)bZ[W̎擾B
     * @param key L[
     * @return bZ[W
     */
    private static String getMessage(String key) {
        return Messages.getString("menu.ContextMenu." + key);
    }

}