package net.argius.stew.gui;

import java.io.*;
import java.util.*;
import java.util.zip.*;

/**
 * NXB
 */
class ClassFinder {

    private String rootPath;
    private ClassLoader classLoader;
    private boolean failMode;

    /**
     * ClassFinder̐B
     * @param rootPath pX
     */
    public ClassFinder(String rootPath) {
        this.rootPath = normalizePath(rootPath);
        this.classLoader = ClassLoader.getSystemClassLoader();
    }

    /**
     * NX[_̐ݒB
     * @param classLoader NX[_
     */
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /**
     * "FailMode"̐ݒB
     * FailModeLɂꍇAOX[ <code>fail(Object)</code> ĂяoB
     * @param failMode FailModeLɂꍇ <code>true</code>
     */
    public void setFailMode(boolean failMode) {
        this.failMode = failMode;
    }

    /**
     * NXB
     * @param file Jnt@C܂̓fBNg
     */
    public final void find(File file) {
        try {
            String name = file.getName();
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; i++) {
                    find(files[i]);
                }
            } else if (name.matches("(?i).+\\.class")) {
                try {
                    filter(resolveClass(file.getCanonicalPath()));
                } catch (Throwable ex) {
                    if (failMode) {
                        fail(file, ex);
                    } else {
                        throw new RuntimeException(ex);
                    }
                }
            } else if (name.matches("(?i).+\\.(jar|zip)")) {
                find(new ZipFile(file));
            }
        } catch (IOException ex) {
            if (failMode) {
                fail(file, ex);
            } else {
                throw new RuntimeException(ex);
            }
        }
    }

    /**
     * NXB
     * @param zipFile ZIP`t@C(Jart@C܂)
     */
    public final void find(ZipFile zipFile) {
        Enumeration en = zipFile.entries();
        while (en.hasMoreElements()) {
            ZipEntry entry = (ZipEntry)en.nextElement();
            String name = entry.getName();
            if (name.matches("(?i).+\\.class")) {
                try {
                    filter(resolveClass(name));
                } catch (Throwable ex) {
                    if (failMode) {
                        fail(name, ex);
                    } else {
                        throw new RuntimeException(ex);
                    }
                }
            }
        }
    }

    /**
     * I[o[ChāANXtB^B
     * @param c NX
     */
    public void filter(Class c) {
        // do nothing
    }

    /**
     * I[o[ChāAFailModȅsB
     * @param object FailModeŏIuWFNg
     * @param cause š
     */
    public void fail(Object object, Throwable cause) {
        // do nothing
    }

    /**
     * NXB
     * t@CVXeŌNX
     * NX[_擾B
     * @param path t@CVXe(ZIPGg܂)̃NXt@C
     * @return Class
     * @throws Throwable NX̉Ɏsꍇ
     */
    protected final Class resolveClass(String path) throws Throwable {
        String s = normalizePath(path);
        if (s.startsWith(rootPath)) {
            s = s.substring(rootPath.length() + 1);
        }
        s = s.replaceFirst("\\.class$", "").replace('/', '.');
        return Class.forName(s, false, classLoader);
    }

    /**
     * pX𐳋KB
     * @param path pX
     * @return KꂽpX
     */
    private static String normalizePath(String path) {
        return path.replaceAll("\\\\", "/");
    }

}
