package net.argius.stew.command;

import java.io.*;
import java.sql.*;

import net.argius.logging.*;
import net.argius.stew.*;
import net.argius.stew.io.*;

/**
 * f[^t@Cɏo͂R}hB
 *
 * gpłR}h́A"SELECT","FIND","REPORT"̂RށB
 * 
 * o͌`́Agqɂ莩IɑIB
 * @see Exporter
 */
public final class Export extends Command {

    private static final Logger log = LoggerFactory.getLogger(Export.class);
    private static final String USAGE = getUsage("export");

    /* (overridden)
     * @see net.argius.stew.CommandInterface#execute(java.sql.Connection, net.argius.stew.Parameter)
     */
    public void execute(Connection conn, Parameter parameter) throws CommandException {
        if (parameter.isEmpty(3)) {
            throw new UsageException(USAGE);
        }
        // 
        int argsIndex = 2;
        String p1 = parameter.get(argsIndex++);
        String p2 = parameter.get(argsIndex);
        boolean withHeader = false;
        if (p2.equalsIgnoreCase("HEADER")) {
            withHeader = true;
            ++argsIndex;
        }
        String p3 = parameter.getAll(argsIndex);
        // s
        try {
            export(conn, p1, withHeader, new Parameter(p3));
            output(Messages.getString("command.export.exported"));
        } catch (IOException ex) {
            throw new CommandException(ex);
        }
    }

    /* (overridden)
     * @see net.argius.stew.Command#isReadOnly()
     */
    public boolean isReadOnly() {
        return true;
    }

    /**
     * GNX|[gsB
     * @param conn RlNV
     * @param pathName o͐t@C̃pX
     * @param withHeader wb_L
     * @param parameter p[^
     * @throws IOException o̓G[ꍇ
     */
    private void export(Connection conn,
                        String pathName,
                        boolean withHeader,
                        Parameter parameter) throws IOException {
        Command command = getCommand(parameter.get(1).replaceAll("\\s+", ""));
        Path path = Path.resolve(env.getCurrentDirectory(), pathName);
        Exporter exporter = Exporter.getExporter(path);
        try {
            if (log.isDebugEnabled()) {
                log.debug("command  : " + command);
                log.debug("exporter : " + exporter);
            }
            OutputProcessor parent = env.getOutputProcessor();
            OutputProcessor output = new ExporterOutputProcessor(exporter, parent, withHeader);
            Environment env = new Environment(this.env);
            env.setOutputProcessor(output);
            command.setEnvironment(env);
            command.execute(conn, parameter);
        } finally {
            exporter.close();
        }
    }

    /**
     * R}h̎擾B
     * @param name R}h
     * @return R}h
     */
    private Command getCommand(String name) {
        Command command;
        if (name.equalsIgnoreCase("SELECT")) {
            command = new Select();
        } else if (name.equalsIgnoreCase("FIND")) {
            command = new Find();
        } else if (name.equalsIgnoreCase("REPORT")) {
            command = new Report();
        } else {
            throw new UsageException(USAGE);
        }
        return command;
    }

}