/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.io;

import java.io.File;
import java.io.IOException;
import java.net.URI;

public final class Path
extends File {
    private static final String PATTERN_SUFFIX = "^.*\\.([^\\.]+)$";

    public Path(File file) {
        super(file.getPath());
    }

    public Path(File file, String string) {
        super(file, string);
    }

    public Path(String string) {
        super(string);
    }

    public Path(String string, String string2) {
        super(new File(string), string2);
    }

    public Path(URI uRI) {
        super(uRI);
    }

    public static Path resolve(File file, File file2) {
        if (file2.isAbsolute()) {
            return new Path(file2.getAbsolutePath());
        }
        return new Path(file, file2.getPath());
    }

    public static Path resolve(File file, String string) {
        return Path.resolve(file, new File(string));
    }

    public static Path resolve(String string, String string2) {
        return Path.resolve(new File(string), string2);
    }

    public String getSuffix() {
        return Path.getSuffix(this.getPath());
    }

    public static String getSuffix(File file) {
        return Path.getSuffix(file.getName());
    }

    public static String getSuffix(String string) {
        if (string.matches(PATTERN_SUFFIX)) {
            return string.replaceFirst(PATTERN_SUFFIX, "$1");
        }
        return "";
    }

    public void makeDirectory() throws IOException {
        Path.makeDirectory(this);
    }

    public static void makeDirectory(File file) throws IOException {
        if (!(file.isDirectory() || file.mkdirs() && file.isDirectory())) {
            throw new IOException("can't make directory: " + file);
        }
    }
}

