/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutFocusTraversalPolicy;
import net.argius.stew.gui.DialogMessage;
import net.argius.stew.gui.Messages;
import net.argius.stew.gui.TextSearch;
import net.argius.stew.gui.TextSearchMatcher;

final class TextSearchPanel
extends JPanel {
    private JTextField text;
    private JCheckBox useRegexCheck;
    private JCheckBox ignoreCaseCheck;
    private TextSearch[] targets;
    private TextSearch target;

    TextSearchPanel(JFrame jFrame, TextSearch[] textSearchArray) {
        this.targets = textSearchArray;
        this.setLayout(new FlowLayout());
        this.setVisible(false);
        final JTextField jTextField = new JTextField(32);
        final JButton jButton = new JButton(this.getMessage("forward"));
        final JButton jButton2 = new JButton(this.getMessage("backward"));
        JCheckBox jCheckBox = new JCheckBox(this.getMessage("useregex"));
        final JCheckBox jCheckBox2 = new JCheckBox(this.getMessage("ignorecase"));
        final JButton jButton3 = new JButton(new ImageIcon(TextSearchPanel.class.getResource("icon.close.gif")));
        jButton.setMargin(new Insets(0, 7, 0, 7));
        jButton2.setMargin(new Insets(0, 7, 0, 7));
        jButton3.setMargin(new Insets(0, 0, 0, 0));
        jButton3.setToolTipText(this.getMessage("close"));
        this.text = jTextField;
        this.useRegexCheck = jCheckBox;
        this.ignoreCaseCheck = jCheckBox2;
        this.add(jButton3);
        this.add(new JLabel("     "));
        this.add(new JLabel(this.getMessage("label")));
        this.add(jTextField);
        this.add(jButton);
        this.add(jButton2);
        this.add(jCheckBox);
        this.add(jCheckBox2);
        final FocusTraversalPolicy focusTraversalPolicy = jFrame.getFocusTraversalPolicy();
        jFrame.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            public Component getComponentAfter(Container container, Component component) {
                if (component == jCheckBox2) {
                    return jButton3;
                }
                return focusTraversalPolicy.getComponentAfter(container, component);
            }

            public Component getComponentBefore(Container container, Component component) {
                if (component == jButton3) {
                    return jCheckBox2;
                }
                return focusTraversalPolicy.getComponentBefore(container, component);
            }
        });
        jTextField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 10) {
                    if (jTextField.getText().length() == 0) {
                        return;
                    }
                    TextSearchPanel.this.startSearch(false);
                    TextSearchPanel.this.requestFocus();
                    jTextField.requestFocus();
                }
            }
        });
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jTextField.getText().length() == 0) {
                    return;
                }
                TextSearchPanel.this.startSearch(false);
                TextSearchPanel.this.requestFocus();
                jButton.requestFocus();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jTextField.getText().length() == 0) {
                    return;
                }
                TextSearchPanel.this.startSearch(true);
                TextSearchPanel.this.requestFocus();
                jButton2.requestFocus();
            }
        });
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextSearchPanel.this.setVisible(false);
            }
        });
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    TextSearchPanel.this.setVisible(false);
                }
            }
        };
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            Font font = component.getFont();
            component.setFont(font.deriveFont(font.getSize2D() * 0.8f));
            component.addKeyListener(keyAdapter);
        }
    }

    private String getMessage(String string) {
        return Messages.getString("pane.TextSearchPane." + string);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.text.requestFocus();
        } else {
            for (int i = 0; i < this.targets.length; ++i) {
                this.targets[i].reset();
            }
            if (this.target != null && this.target instanceof Component) {
                Component component = (Component)((Object)this.target);
                component.requestFocus();
            }
        }
    }

    public void setTarget(TextSearch textSearch) {
        this.target = textSearch;
    }

    void startSearch(boolean bl) {
        int n;
        String string = this.text.getText();
        boolean bl2 = this.useRegexCheck.isSelected();
        boolean bl3 = this.ignoreCaseCheck.isSelected();
        TextSearchMatcher textSearchMatcher = new TextSearchMatcher(string, bl2, bl3);
        textSearchMatcher.setBackward(bl);
        textSearchMatcher.setContinuously(true);
        for (n = 0; n < this.targets.length; ++n) {
            this.targets[n].reset();
        }
        n = this.target.search(textSearchMatcher) ? 1 : 0;
        if (n == 0) {
            String string2 = this.getMessage("message.notfound");
            String string3 = MessageFormat.format(string2, string);
            Container container = this.target instanceof Component ? ((Component)((Object)this.target)).getParent() : this.getParent();
            DialogMessage.alert(container, string3);
        }
    }
}

