/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.Vector;
import javax.swing.CellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.ColumnOrder;
import net.argius.stew.Environment;
import net.argius.stew.gui.ContextMenu;
import net.argius.stew.gui.DialogMessage;
import net.argius.stew.gui.FormedFont;
import net.argius.stew.gui.Messages;
import net.argius.stew.gui.ResultSetTableAction;
import net.argius.stew.gui.ResultSetTableHeaderCellRenderer;
import net.argius.stew.gui.ResultSetTableModel;
import net.argius.stew.gui.ResultSetTableMonitor;
import net.argius.stew.gui.ResultSetTableNullValueCellRenderer;
import net.argius.stew.gui.ResultSetTableRowHeader;
import net.argius.stew.gui.ResultSetValueComparator;
import net.argius.stew.gui.TextSearch;
import net.argius.stew.gui.TextSearchMatcher;
import net.argius.stew.io.Exporter;

class ResultSetTable
extends JTable
implements TextSearch {
    private static final Logger log = LoggerFactory.getLogger(ResultSetTable.class);
    private final Environment env;
    private final ResultSetTableHeaderCellRenderer headerRenderer;
    private final ResultSetTableRowHeader rowHeader;
    private int limitCount;
    private boolean[] sortedAscArray;
    private String columnAdjustMode;
    private int dragStartColumn;
    private volatile KeyEvent lastKeyEvent;

    ResultSetTable(Environment environment) {
        this.env = environment;
        this.headerRenderer = new ResultSetTableHeaderCellRenderer(this.getTableHeader().getDefaultRenderer());
        this.rowHeader = new ResultSetTableRowHeader(this);
        this.limitCount = Integer.MAX_VALUE;
        this.sortedAscArray = new boolean[0];
        this.initialize();
    }

    int getLimitCount() {
        return this.limitCount;
    }

    public void setLimitCount(int n) {
        this.limitCount = n;
    }

    String getColumnAdjustMode() {
        return this.columnAdjustMode;
    }

    void setColumnAdjustMode(String string) {
        this.columnAdjustMode = string;
    }

    private void initialize() {
        ResultSetTableAction.bindAction(this);
        this.getTableHeader().setDefaultRenderer(this.headerRenderer);
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        ContextMenu contextMenu = new ContextMenu(this);
        this.addMouseListener(contextMenu);
        jTableHeader.addMouseListener(contextMenu);
        jTableHeader.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ResultSetTable.this.onTableHeaderClicked(mouseEvent);
            }
        });
        jTableHeader.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                ResultSetTable.this.onTableHeaderClicked(mouseEvent);
            }
        });
        this.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent keyEvent) {
                ResultSetTable.this.setLastKeyEvent(keyEvent);
            }

            public void keyReleased(KeyEvent keyEvent) {
                ResultSetTable.this.setLastKeyEvent(keyEvent);
            }

            public void keyPressed(KeyEvent keyEvent) {
                ResultSetTable.this.setLastKeyEvent(keyEvent);
            }
        });
    }

    void setLastKeyEvent(KeyEvent keyEvent) {
        this.lastKeyEvent = keyEvent;
    }

    public void setFont(Font font) {
        super.setFont(font);
        double d = this.getSizeRate(font);
        this.setRowHeight((int)(16.0 * d));
        TableColumnModel tableColumnModel = this.getColumnModel();
        if (tableColumnModel != null && tableColumnModel.getColumnCount() > 0) {
            this.getTableHeader().setFont(font);
            TableColumn tableColumn = tableColumnModel.getColumn(0);
            double d2 = this.getSizeRate(this.getFont()) * 10.0;
            tableColumn.setPreferredWidth((int)(4.0 * d2));
        }
    }

    protected void configureEnclosingScrollPane() {
        Container container;
        super.configureEnclosingScrollPane();
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                return;
            }
            jScrollPane.setRowHeaderView(this.rowHeader);
        }
    }

    public void editingStopped(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object instanceof CellEditor) {
            CellEditor cellEditor = (CellEditor)object;
            ResultSetTableModel resultSetTableModel = (ResultSetTableModel)this.getModel();
            if (!resultSetTableModel.isInsertRow(this.getEditingRow())) {
                resultSetTableModel.updateCellEdited(this, cellEditor);
            }
            this.validate();
        }
        super.editingStopped(changeEvent);
    }

    public TableCellEditor getCellEditor() {
        DefaultCellEditor defaultCellEditor;
        Component component;
        TableCellEditor tableCellEditor = super.getCellEditor();
        if (tableCellEditor instanceof DefaultCellEditor && (component = (defaultCellEditor = (DefaultCellEditor)tableCellEditor).getComponent()) != null) {
            if (!component.isEnabled()) {
                log.warn("forced to enable CellEditor");
                component.setEnabled(true);
            }
            component.setFont(this.getFont());
            component.setBackground(Color.PINK);
        }
        return tableCellEditor;
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        if (this.getValueAt(n, n2) != null) {
            return super.getCellRenderer(n, n2);
        }
        return ResultSetTableNullValueCellRenderer.INSTANCE;
    }

    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        boolean bl = super.editCellAt(n, n2, eventObject);
        if (bl && this.editorComp instanceof JTextField && this.lastKeyEvent != null && this.lastKeyEvent.getKeyCode() != 113) {
            JTextField jTextField = (JTextField)this.editorComp;
            jTextField.selectAll();
        }
        return bl;
    }

    public boolean search(TextSearchMatcher textSearchMatcher) {
        int n = this.getRowCount();
        if (n <= 0) {
            return false;
        }
        int n2 = this.getColumnCount();
        boolean bl = textSearchMatcher.isBackward();
        int n3 = bl ? -1 : 1;
        int n4 = bl ? n - 1 : 0;
        int n5 = bl ? 0 : n - 1;
        int n6 = bl ? n2 - 1 : 0;
        int n7 = bl ? 0 : n2 - 1;
        int n8 = n4;
        int n9 = n6;
        if (this.getSelectedColumnCount() > 0) {
            n9 = this.getSelectedColumn();
            n8 = this.getSelectedRow() + n3;
            if (bl) {
                if (n8 < 0) {
                    if (--n9 < 0) {
                        return false;
                    }
                    n8 = n4;
                }
            } else if (n8 >= n) {
                if (++n9 >= n2) {
                    return false;
                }
                n8 = n4;
            }
        }
        while (bl ? n9 >= n7 : n9 <= n7) {
            while (bl ? n8 >= n5 : n8 <= n5) {
                if (textSearchMatcher.find(String.valueOf(this.getValueAt(n8, n9)))) {
                    this.changeSelection(n8, n9, false, false);
                    this.requestFocus();
                    return true;
                }
                n8 += n3;
            }
            n8 = n4;
            n9 += n3;
        }
        return false;
    }

    public void reset() {
    }

    private double getSizeRate(Font font) {
        return (double)font.getSize() / 1.0 / (double)FormedFont.Regular.getSize();
    }

    boolean isShowColumnNumber() {
        return this.headerRenderer.isShowNumber();
    }

    void setShowColumnNumber(boolean bl) {
        this.headerRenderer.setShowNumber(bl);
    }

    final void onTableHeaderClicked(MouseEvent mouseEvent) {
        if (this.getRowCount() == 0) {
            return;
        }
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            boolean bl;
            int n = mouseEvent.getID();
            boolean bl2 = n == 501;
            boolean bl3 = bl = n == 506;
            if (bl2 || bl) {
                int n2;
                int n3;
                int n4;
                if (!mouseEvent.isControlDown() && !mouseEvent.isShiftDown()) {
                    this.clearSelection();
                }
                if ((n4 = this.columnAtPoint(point)) < 0 || this.getColumnCount() <= n4) {
                    return;
                }
                if (bl2) {
                    if (mouseEvent.isShiftDown()) {
                        n3 = this.dragStartColumn;
                        n2 = n4;
                    } else {
                        this.dragStartColumn = n4;
                        n3 = n4;
                        n2 = n4;
                    }
                } else if (bl) {
                    n3 = this.dragStartColumn;
                    n2 = n4;
                } else {
                    return;
                }
                this.selectColumn(n3, n2);
                this.requestFocus();
            }
        }
    }

    void selectColumn(int n) {
        this.selectColumn(n, n);
    }

    void selectColumn(int n, int n2) {
        if (this.getRowCount() > 0) {
            this.addColumnSelectionInterval(n, n2);
            this.addRowSelectionInterval(this.getRowCount() - 1, 0);
        }
    }

    void fitColumn0() {
    }

    final void onTableClicked(MouseEvent mouseEvent) {
    }

    void requestSort(int n) {
        if (n > 0 && this.getRowCount() > 100000) {
            String string = Messages.getString("window.ResultSetTable.sort.confirm");
            int n2 = DialogMessage.confirmYesNo(this.getParent(), string);
            if (n2 != 0) {
                return;
            }
        }
        this.sort(n);
    }

    private void sort(final int n) {
        boolean bl = this.sortedAscArray[n];
        final ResultSetValueComparator resultSetValueComparator = new ResultSetValueComparator();
        final int n2 = bl ? -1 : 1;
        Collections.sort(((DefaultTableModel)this.getModel()).getDataVector(), new Comparator(){

            public int compare(Object object, Object object2) {
                List list = (List)object;
                List list2 = (List)object2;
                return resultSetValueComparator.compare(list.get(n), list2.get(n)) * n2;
            }
        });
        for (int i = 0; i < this.sortedAscArray.length; ++i) {
            this.sortedAscArray[i] = n == i && !bl;
        }
        this.repaint();
    }

    void changeColumnWidth(double d) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            int n2 = (int)((double)tableColumn.getWidth() * d);
            tableColumn.setPreferredWidth(n2);
        }
    }

    void adjustColumnWidth() {
        boolean bl;
        boolean bl2;
        if (this.columnAdjustMode == null) {
            return;
        }
        if (this.columnAdjustMode.equalsIgnoreCase("header")) {
            bl2 = true;
            bl = false;
        } else if (this.columnAdjustMode.equalsIgnoreCase("value")) {
            bl2 = false;
            bl = true;
        } else if (this.columnAdjustMode.equalsIgnoreCase("header-and-value")) {
            bl2 = true;
            bl = true;
        } else {
            bl2 = false;
            bl = false;
        }
        int n = this.getRowCount();
        if (!bl2 && bl && n == 0) {
            return;
        }
        float f = (float)this.getParent().getWidth() * 0.8f;
        TableColumnModel tableColumnModel = this.getColumnModel();
        JTableHeader jTableHeader = this.getTableHeader();
        int n2 = this.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            Object object;
            TableCellRenderer tableCellRenderer;
            float f2 = 0.0f;
            if (bl2) {
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                tableCellRenderer = tableColumn.getHeaderRenderer();
                if (tableCellRenderer == null) {
                    tableCellRenderer = jTableHeader.getDefaultRenderer();
                }
                if (tableCellRenderer != null) {
                    object = tableCellRenderer.getTableCellRendererComponent(this, tableColumn.getHeaderValue(), false, false, 0, i);
                    f2 = (float)((Component)object).getPreferredSize().width * 1.5f;
                }
            }
            if (bl) {
                for (int j = 0; j < n; ++j) {
                    tableCellRenderer = this.getCellRenderer(j, i);
                    if (tableCellRenderer == null) continue;
                    object = String.valueOf(this.getValueAt(j, i));
                    Component component = tableCellRenderer.getTableCellRendererComponent(this, object, false, false, j, i);
                    if ((f2 = Math.max(f2, (float)component.getPreferredSize().width)) >= f) break;
                }
            }
            int n3 = Math.round(f2 > f ? f : f2) + 1;
            tableColumnModel.getColumn(i).setPreferredWidth(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void export(File file) throws IOException {
        Exporter exporter = Exporter.getExporter(file);
        try {
            int n = this.getColumnCount();
            int n2 = this.getRowCount();
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
            Vector<Vector> vector = defaultTableModel.getDataVector();
            for (int i = 0; i < n2; ++i) {
                List list = (List)vector.get(i);
                exporter.addRow(list.subList(1, n).toArray());
            }
        }
        finally {
            exporter.close();
        }
    }

    int outputResultSet(ResultSet resultSet, ColumnOrder columnOrder, String string) throws SQLException {
        int n;
        Object object;
        int n2;
        int n3;
        int[] nArray;
        int n4;
        final JTableHeader jTableHeader = this.tableHeader;
        final DefaultTableModel defaultTableModel = (DefaultTableModel)this.rowHeader.getModel();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ResultSetTable.this.setVisible(false);
                jTableHeader.setVisible(false);
                defaultTableModel.setRowCount(0);
            }
        });
        boolean bl = columnOrder.size() > 0;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        if (bl) {
            n4 = columnOrder.size();
            nArray = new int[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                int n5 = columnOrder.getOrder(n3);
                nArray[n3] = resultSetMetaData.getColumnType(n5);
            }
        } else {
            n4 = columnOrder.size();
            n4 = resultSetMetaData.getColumnCount();
            nArray = new int[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                nArray[n3] = resultSetMetaData.getColumnType(n3 + 1);
            }
        }
        ResultSetTableMonitor resultSetTableMonitor = new ResultSetTableMonitor();
        final ResultSetTableModel resultSetTableModel = new ResultSetTableModel(n4, nArray, resultSetTableMonitor, this.rowHeader);
        for (n2 = 0; resultSet.next() && n2 < this.limitCount; ++n2) {
            object = new Vector();
            for (n = 0; n < n4; ++n) {
                int n6 = bl ? columnOrder.getOrder(n) : n + 1;
                ((Vector)object).add(resultSet.getObject(n6));
            }
            resultSetTableModel.addRow((Vector<?>)object);
        }
        object = new String[n4];
        for (n = 0; n < n4; ++n) {
            String string2 = bl ? columnOrder.getName(n) : resultSetMetaData.getColumnName(n + 1);
            object[n] = string2;
        }
        this.sortedAscArray = new boolean[n4];
        if (!this.env.getCurrentConnector().isReadOnly()) {
            resultSetTableMonitor.prepare(resultSet, string);
        }
        EventQueue.invokeLater(new Runnable((String[])object, jTableHeader){
            private final /* synthetic */ String[] val$headerValues;
            private final /* synthetic */ JTableHeader val$header;
            {
                this.val$headerValues = stringArray;
                this.val$header = jTableHeader;
            }

            public void run() {
                ResultSetTable.this.setModel(resultSetTableModel);
                int n = ResultSetTable.this.getColumnCount();
                TableColumnModel tableColumnModel = ResultSetTable.this.getColumnModel();
                for (int i = 0; i < n; ++i) {
                    TableColumn tableColumn = tableColumnModel.getColumn(i);
                    tableColumn.setHeaderValue(this.val$headerValues[i]);
                }
                ResultSetTable.this.adjustColumnWidth();
                resultSetTableModel.addTableModelListener(ResultSetTable.this);
                this.setUpdatableSign();
                ResultSetTable.this.validate();
                this.val$header.setVisible(true);
                ResultSetTable.this.setVisible(true);
            }

            private void setUpdatableSign() {
                Container container = ResultSetTable.this.getParent();
                if (container != null && container.getParent() instanceof JScrollPane) {
                    JScrollPane jScrollPane = (JScrollPane)container.getParent();
                    String string = "icon.updatable." + resultSetTableModel.isUpdatable() + ".gif";
                    jScrollPane.setCorner("UPPER_LEFT_CORNER", new JLabel(new ImageIcon(this.getClass().getResource(string)), 0));
                }
            }
        });
        return n2;
    }
}

