/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.gui;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.argius.stew.Connector;
import net.argius.stew.LocalSystem;
import net.argius.stew.Password;
import net.argius.stew.PbePassword;
import net.argius.stew.PlainTextPassword;
import net.argius.stew.StringClass;
import net.argius.stew.gui.ClassFinder;
import net.argius.stew.gui.DialogMessage;
import net.argius.stew.gui.FlexibleDialogBase;
import net.argius.stew.gui.Messages;

final class ConnectorEditDialog
extends FlexibleDialogBase {
    private static final int TEXT_SIZE = 32;
    private static final Color COLOR_ESSENTIAL = new Color(0xFFF099);
    private static File currentDirectory = new File(".");
    private final List lisnerList = new LinkedList();
    private final JTextField tId;
    private final JTextField tName;
    private final JTextField tDriver;
    private final JTextField tClasspath;
    private final JTextField tUrl;
    private final JTextField tUser;
    private final JPasswordField tPassword;
    private final JComboBox cPasswordClass;
    private final JCheckBox cReadOnly;
    private final JCheckBox cUsesAutoRollback;
    static /* synthetic */ Class class$java$sql$Driver;

    ConnectorEditDialog(JDialog jDialog, Connector connector) {
        super(jDialog);
        this.setTitle(ConnectorEditDialog.getMessage("title"));
        this.initializeKeyBind(this);
        String string = connector.getId();
        this.tId = this.createJTextField(string, true);
        this.addComponent(new JLabel(ConnectorEditDialog.getMessage("connector.id")), false);
        this.addComponent(this.tId, true);
        this.tName = this.createJTextField(connector.getName(), false);
        this.addComponent(new JLabel(ConnectorEditDialog.getMessage("connector.name")), false);
        this.addComponent(this.tName, true);
        this.tClasspath = this.createJTextField(connector.getClasspath(), false);
        JButton jButton = this.createJButton(ConnectorEditDialog.getMessage("button.search.file"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorEditDialog.this.onButtonClasspathClicked();
            }
        });
        this.addComponent(new JLabel(ConnectorEditDialog.getMessage("connector.classpath")), false);
        this.addComponent(this.tClasspath, false);
        this.addComponent(jButton, true);
        this.tDriver = this.createJTextField(connector.getDriver(), true);
        JButton jButton2 = this.createJButton(ConnectorEditDialog.getMessage("button.search.driver"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorEditDialog.this.onButtonDriverClicked();
            }
        });
        this.addComponent(new JLabel(ConnectorEditDialog.getMessage("connector.driver")), false);
        this.addComponent(this.tDriver, false);
        this.addComponent(jButton2, true);
        this.tUrl = this.createJTextField(connector.getUrl(), true);
        this.addComponent(new JLabel(ConnectorEditDialog.getMessage("connector.url")), false);
        this.addComponent(this.tUrl, true);
        this.tUser = this.createJTextField(connector.getUser(), true);
        this.addComponent(new JLabel(ConnectorEditDialog.getMessage("connector.user")), false);
        this.addComponent(this.tUser, true);
        this.tPassword = new JPasswordField(32);
        this.tPassword.setBackground(COLOR_ESSENTIAL);
        Password password = connector.getPassword();
        if (!StringClass.isBlank(string) && password.hasPassword()) {
            this.tPassword.setText(password.getRowString());
        }
        this.addComponent(new JLabel(ConnectorEditDialog.getMessage("connector.password")), false);
        this.addComponent(this.tPassword, true);
        PasswordItem[] passwordItemArray = new PasswordItem[]{new PasswordItem(PlainTextPassword.class), new PasswordItem(PbePassword.class)};
        this.cPasswordClass = new JComboBox<PasswordItem>(passwordItemArray);
        this.cPasswordClass.setEditable(true);
        for (int i = 0; i < passwordItemArray.length; ++i) {
            if (passwordItemArray[i].getPasswordClass() != password.getClass()) continue;
            this.cPasswordClass.setSelectedIndex(i);
            break;
        }
        this.addComponent(new JLabel(ConnectorEditDialog.getMessage("connector.encryption")), false);
        this.addComponent(this.cPasswordClass, true);
        this.cReadOnly = new JCheckBox(ConnectorEditDialog.getMessage("connector.readonly"), connector.isReadOnly());
        this.addComponent(this.cReadOnly, true);
        this.cUsesAutoRollback = new JCheckBox(ConnectorEditDialog.getMessage("connector.autorollback"), connector.usesAutoRollback());
        this.addComponent(this.cUsesAutoRollback, true);
        JPanel jPanel = new JPanel(new GridLayout(1, 3, 16, 0));
        JButton jButton3 = this.createJButton(ConnectorEditDialog.getMessage("button.register"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorEditDialog.this.onButtonSubmitClicked();
            }
        });
        this.initializeKeyBind(jButton3);
        jPanel.add(jButton3);
        JButton jButton4 = this.createJButton(ConnectorEditDialog.getMessage("button.try.connect"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorEditDialog.this.onButtonTryConnectClicked();
            }
        });
        this.initializeKeyBind(jButton4);
        jPanel.add(jButton4);
        JButton jButton5 = this.createJButton(ConnectorEditDialog.getMessage("button.cancel"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorEditDialog.this.onButtonCancelClicked();
            }
        });
        this.initializeKeyBind(jButton5);
        jPanel.add(jButton5);
        this.c.gridwidth = 0;
        this.c.insets = new Insets(12, 0, 12, 0);
        this.c.anchor = 10;
        this.addComponent(jPanel, false);
        this.pack();
    }

    private JTextField createJTextField(String string, boolean bl) {
        JTextField jTextField = new JTextField(32);
        if (string != null) {
            jTextField.setText(string);
            jTextField.setCaretPosition(0);
        }
        if (bl) {
            jTextField.setBackground(COLOR_ESSENTIAL);
        }
        return jTextField;
    }

    void addChangeListener(ChangeListener changeListener) {
        this.lisnerList.add(changeListener);
    }

    private Connector createConnector() {
        Object object;
        String string = this.tId.getText();
        Properties properties = new Properties();
        properties.setProperty("name", this.tName.getText());
        properties.setProperty("driver", this.tDriver.getText());
        properties.setProperty("classpath", this.tClasspath.getText());
        properties.setProperty("url", this.tUrl.getText());
        properties.setProperty("user", this.tUser.getText());
        properties.setProperty("readonly", Boolean.toString(this.cReadOnly.isSelected()));
        properties.setProperty("rollback", Boolean.toString(this.cUsesAutoRollback.isSelected()));
        Object object2 = this.cPasswordClass.getSelectedItem();
        if (object2 != null && object2 instanceof PasswordItem && !((PasswordItem)(object = (PasswordItem)object2)).getPasswordClass().equals(PlainTextPassword.class)) {
            properties.setProperty("password.class", ((PasswordItem)object).getName());
        }
        object = new Connector(string, properties);
        ((Connector)object).getPassword().setRowString(String.valueOf(this.tPassword.getPassword()));
        return object;
    }

    void onButtonClasspathClicked() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(currentDirectory);
        jFileChooser.setDialogTitle(ConnectorEditDialog.getMessage("dialog.search.file.header"));
        jFileChooser.setApproveButtonText(ConnectorEditDialog.getMessage("dialog.search.file.button"));
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.showDialog(this, null);
        File file = jFileChooser.getSelectedFile();
        if (file != null) {
            this.tClasspath.setText(file.getPath());
            currentDirectory = file.getParentFile();
        }
    }

    void onButtonDriverClicked() {
        Object object;
        String string = this.tClasspath.getText();
        if (StringClass.isBlank(string)) {
            object = ConnectorEditDialog.getMessage("confirm.searchsystemclasspath");
            if (0 != DialogMessage.confirmOkCancel(this, (String)object)) {
                return;
            }
            string = LocalSystem.getProperty("java.class.path");
        }
        object = new LinkedHashSet();
        String[] stringArray = string.split(File.pathSeparator);
        for (int i = 0; i < stringArray.length; ++i) {
            URL[] uRLArray;
            String string2 = stringArray[i];
            File file = new File(string2);
            try {
                uRLArray = new URL[]{file.toURL()};
            }
            catch (MalformedURLException malformedURLException) {
                continue;
            }
            ClassFinder classFinder = new ClassFinder(string2, (Set)object){
                private final /* synthetic */ Set val$classes;
                {
                    this.val$classes = set;
                    super(string);
                }

                public void filter(Class clazz) {
                    if ((class$java$sql$Driver == null ? (class$java$sql$Driver = ConnectorEditDialog.class$("java.sql.Driver")) : class$java$sql$Driver).isAssignableFrom(clazz)) {
                        this.val$classes.add(clazz.getName());
                    }
                }
            };
            Object t = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new URLClassLoader(uRLArray);
                }
            });
            classFinder.setClassLoader((URLClassLoader)t);
            classFinder.setFailMode(true);
            classFinder.find(file);
        }
        if (object.isEmpty()) {
            DialogMessage.alert(this, ConnectorEditDialog.getMessage("search.driver.classnotfound"));
        } else {
            Object object2 = DialogMessage.select(this, ConnectorEditDialog.getMessage("dialog.search.driver.header"), object.toArray());
            if (object2 != null) {
                this.tDriver.setText((String)object2);
                this.tDriver.setCaretPosition(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onButtonTryConnectClicked() {
        try {
            Connector connector = this.createConnector();
            Connection connection = connector.getConnection();
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                printWriter.println(ConnectorEditDialog.getMessage("try.connect"));
                printWriter.print(databaseMetaData.getDatabaseProductVersion());
                printWriter.print(databaseMetaData.getDatabaseProductName());
                DialogMessage.notice(this, ((Object)stringWriter).toString());
            }
            finally {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            SQLException sQLException2;
            SQLException sQLException3;
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.println(sQLException.getMessage());
            while ((sQLException3 = sQLException2.getNextException()) != null && sQLException3 != sQLException2) {
                printWriter.println(sQLException3.getMessage());
                sQLException2 = sQLException3;
            }
            DialogMessage.alert(this, ((Object)stringWriter).toString());
        }
        catch (Throwable throwable) {
            this.onError(throwable);
        }
    }

    void onButtonSubmitClicked() {
        try {
            Connector connector = this.createConnector();
            ChangeEvent changeEvent = new ChangeEvent(connector);
            int n = this.lisnerList.size();
            for (int i = 0; i < n; ++i) {
                ChangeListener changeListener = (ChangeListener)this.lisnerList.get(i);
                changeListener.stateChanged(changeEvent);
            }
            this.dispose();
        }
        catch (RuntimeException runtimeException) {
            this.onError(runtimeException);
        }
    }

    void onButtonCancelClicked() {
        this.dispose();
    }

    private static String getMessage(String string) {
        return Messages.getString("dialog.ConnectorEditDialog." + string);
    }

    private static final class PasswordItem {
        final Class passwordClass;

        PasswordItem(Class clazz) {
            this.passwordClass = clazz;
        }

        Class getPasswordClass() {
            return this.passwordClass;
        }

        String getName() {
            return this.toString();
        }

        public String toString() {
            return this.passwordClass.getName();
        }
    }
}

