/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.DynamicLoader;
import net.argius.stew.DynamicLoadingException;
import net.argius.stew.Password;
import net.argius.stew.PlainTextPassword;
import net.argius.stew.StringClass;

public final class Connector {
    private static final Logger log = LoggerFactory.getLogger(Connector.class);
    private final String id;
    private final Properties props;
    private final Password password;

    public Connector(String string, Properties properties) {
        if (!string.matches("^[A-Za-z0-9]*$")) {
            throw new IllegalArgumentException("illegal id : " + string);
        }
        this.id = string;
        this.props = properties;
        this.password = Connector.createPasswordInstance(properties.getProperty("password.class"));
        this.password.setTransformedString(properties.getProperty("password"));
    }

    private static Password createPasswordInstance(String string) {
        if (!StringClass.isBlank(string)) {
            try {
                return (Password)DynamicLoader.newInstance(string);
            }
            catch (DynamicLoadingException dynamicLoadingException) {
                log.warn("", dynamicLoadingException);
            }
        }
        return new PlainTextPassword();
    }

    public Connector(String string, Connector connector) {
        this(string, new Properties(connector.props));
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.props.getProperty("name");
    }

    public String getClasspath() {
        return this.props.getProperty("classpath", "");
    }

    public String getDriver() {
        return this.props.getProperty("driver");
    }

    public String getUrl() {
        return this.props.getProperty("url");
    }

    public String getUser() {
        return this.props.getProperty("user");
    }

    public Password getPassword() {
        return this.password;
    }

    public boolean isReadOnly() {
        String string = this.props.getProperty("readonly");
        return Boolean.valueOf(string);
    }

    public boolean usesAutoRollback() {
        String string = this.props.getProperty("rollback");
        return Boolean.valueOf(string);
    }

    protected Properties getProperties() {
        return this.props;
    }

    public Connection getConnection() throws SQLException {
        try {
            Driver driver = Connector.loadDriver(this.getDriver(), this.getClasspath());
            Properties properties = new Properties();
            properties.setProperty("user", this.getUser());
            properties.setProperty("password", this.getPassword().getRowString());
            if (!driver.acceptsURL(this.getUrl())) {
                throw new SQLException("invalid url : " + this.getUrl());
            }
            if (log.isInfoEnabled()) {
                log.info("driver.connect start");
            }
            Connection connection = driver.connect(this.getUrl(), properties);
            if (log.isInfoEnabled()) {
                log.info("driver.connect end");
            }
            if (connection == null) {
                throw new IllegalStateException("driver returned null");
            }
            return connection;
        }
        catch (DynamicLoadingException dynamicLoadingException) {
            throw new SQLException(dynamicLoadingException.toString());
        }
    }

    private static Driver loadDriver(String string, String string2) {
        String[] stringArray = string2.split(File.pathSeparator);
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                arrayList.add(new File(stringArray[i]).toURL());
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        URL[] uRLArray = arrayList.toArray(new URL[arrayList.size()]);
        if (log.isInfoEnabled()) {
            log.info("driver.instantiate start");
        }
        Object object = DynamicLoader.newInstance(string, uRLArray);
        if (log.isInfoEnabled()) {
            log.info("driver.instantiate end");
        }
        return (Driver)object;
    }

    public String toString() {
        return "Connector:" + this.id;
    }
}

