package net.argius.stew.io;

import java.io.*;
import java.net.*;

/**
 * pXB
 */
public final class Path extends File {

    private static final String PATTERN_SUFFIX = "^.*\\.([^\\.]+)$";

    /**
     * Path̐B
     * @param file t@C
     */
    public Path(File file) {
        super(file.getPath());
    }

    /**
     * Path̐B
     * @param parent epX
     * @param child qpX
     */
    public Path(File parent, String child) {
        super(parent, child);
    }

    /**
     * Path̐B
     * @param pathname pX
     */
    public Path(String pathname) {
        super(pathname);
    }

    /**
     * Path̐B
     * @param parent epX
     * @param child qpX
     */
    public Path(String parent, String child) {
        super(new File(parent), child);
    }

    /**
     * Path̐B
     * @param uri URI
     */
    public Path(URI uri) {
        super(uri);
    }

    /**
     * pXB
     * @param parent epX
     * @param child qpX
     * @return pX
     */
    public static Path resolve(File parent, File child) {
        if (child.isAbsolute()) {
            return new Path(child.getAbsolutePath());
        } else {
            return new Path(parent, child.getPath());
        }
    }

    /**
     * pXB
     * @param parent epX
     * @param child qpX
     * @return pX
     */
    public static Path resolve(File parent, String child) {
        return resolve(parent, new File(child));
    }

    /**
     * pXB
     * @param parent epX
     * @param child qpX
     * @return pX
     */
    public static Path resolve(String parent, String child) {
        return resolve(new File(parent), child);
    }

    /**
     * gq̎擾B
     * @return gq
     */
    public String getSuffix() {
        return getSuffix(getPath());
    }

    /**
     * gq̎擾B
     * @param file t@C
     * @return gq
     */
    public static String getSuffix(File file) {
        return getSuffix(file.getName());
    }

    /**
     * gq̎擾B
     * @param pathName pX
     * @return gq
     */
    public static String getSuffix(String pathName) {
        if (pathName.matches(PATTERN_SUFFIX)) {
            return pathName.replaceFirst(PATTERN_SUFFIX, "$1");
        }
        return "";
    }

    /**
     * fBNg쐬B
     * @throws IOException o̓G[ꍇ
     */
    public void makeDirectory() throws IOException {
        makeDirectory(this);
    }

    /**
     * fBNg쐬B
     * @param file File
     * @throws IOException o̓G[ꍇ
     */
    public static void makeDirectory(File file) throws IOException {
        if (!file.isDirectory()) {
            if (!file.mkdirs() || !file.isDirectory()) {
                throw new IOException("can't make directory: " + file);
            }
        }
    }

}