package net.argius.stew;

import java.io.*;
import java.util.*;

import net.argius.logging.*;

/**
 * [JVXeB
 */
public final class LocalSystem {

    private static final String FILE_PROPERTIES = "stew.properties";

    private static final Logger log = LoggerFactory.getLogger(LocalSystem.class);

    private static File directory;
    private static Properties props;

    static {
        directory = initializeDirectory();
        props = initializeProperties();
    }

    /**
     * LocalSystem̐B
     */
    private LocalSystem() {
        // empty
    }

    /**
     * VXefBNg̏B
     * @return VXefBNg
     */
    private static File initializeDirectory() {
        File directory;
        String path = System.getProperty(PropertyKey.PROPERTIES);
        if (path == null) {
            directory = new File(System.getProperty("user.home"), ".stew");
        } else {
            File file = new File(path);
            if (file.isDirectory()) {
                directory = file;
            } else {
                directory = file.getParentFile();
                if (directory == null) {
                    directory = new File(".stew");
                }
            }
        }
        if (!directory.exists()) {
            directory.mkdirs();
        }
        return directory;
    }

    /**
     * vpeB̏B
     * @return vpeB
     */
    private static Properties initializeProperties() {
        Properties group3 = System.getProperties();
        Properties group2 = new Properties(group3);
        try {
            group2.putAll(getFileProperties());
        } catch (IOException ex) {
            log.warn("", ex);
        }
        Properties group1 = new Properties(group2);
        if (log.isTraceEnabled()) {
            Properties[] propsArray = {group3, group2};
            for (int i = 0; i < propsArray.length; i++) {
                Properties p = propsArray[i];
                List list = new ArrayList(p.keySet());
                Collections.sort(list);
                Writer buffer = new StringWriter();
                PrintWriter out = new PrintWriter(buffer);
                out.println();
                out.println("--- property group " + (3 - i) + " ---");
                for (Iterator it = list.iterator(); it.hasNext();) {
                    String key = (String)it.next();
                    out.println(key + '=' + p.getProperty(key));
                }
                log.trace(buffer);
            }
        }
        return group1;
    }

    /**
     * vpeBt@C"stew.properties"AΓǂݍށB
     * t@C鏇͈ȉ̒ʂB
     * <ol>
     * <li>VXevpeB"net.argius.stew.properties"ŎꂽpX
     *     (pXfBNgȂAstew.propertieŝƌȂ)
     * <li>NXpX
     * <li>VXefBNg
     * </ol>
     * @return Properties
     * @throws IOException o̓G[ꍇ
     */
    private static Properties getFileProperties() throws IOException {
        Properties props = new Properties();
        // VXevpeB
        String path = System.getProperty(PropertyKey.PROPERTIES);
        if (path != null) {
            File file = new File(path);
            if (file.isDirectory()) {
                file = new File(file, FILE_PROPERTIES);
            }
            if (file.exists()) {
                InputStream is = new FileInputStream(file);
                try {
                    props.load(is);
                    return props;
                } finally {
                    is.close();
                }
            }
        }
        // NXpX
        String resourcePath = "/" + FILE_PROPERTIES;
        InputStream res = LocalSystem.class.getResourceAsStream(resourcePath);
        if (res != null) {
            props.load(res);
            return props;
        }
        // VXefBNg
        File currentdirfile = new File(directory, FILE_PROPERTIES);
        if (currentdirfile.exists()) {
            InputStream is = new FileInputStream(currentdirfile);
            try {
                props.load(is);
                return props;
            } finally {
                is.close();
            }
        }
        return props;
    }

    /**
     * VXefBNg̎擾B
     * @return VXefBNg
     */
    public static File getDirectory() {
        return directory;
    }

    /**
     * vpeB̎擾B
     * K<code>null</code>łȂlԂB
     * @param key vpeBL[
     * @return vpeBl
     */
    public static String getProperty(String key) {
        String value = props.getProperty(key);
        if (value == null) {
            return StringClass.EMPTY;
        } else {
            return value;
        }
    }

    /**
     * vpeB̐ݒB
     * @param key L[
     * @param value l
     * @return ݒ肷OɊɒlݒ肳Ăꍇ͂̒lAłȂ <code>null</code>
     */
    public static Object setProperty(String key, String value) {
        return props.setProperty(key, value);
    }

    /**
     * w肳ꂽL[vpeBɐݒ肳Ă邩ǂ𒲍B
     * @param key vpeBL[
     * @return w肳ꂽL[vpeBɐݒ肳ĂȂ<code>true</code>AłȂ<code>false</code>
     */
    public static boolean containsKey(String key) {
        return props.getProperty(key) != null;
    }

}