package net.argius.stew;

import java.util.*;

/**
 * RlN^}bvB
 * RlN^ݒ̊֘AtsB
 */
public final class ConnectorMap extends AbstractMap {

    private final Map map;

    /**
     * ConnectorMap̐B
     */
    public ConnectorMap() {
        this.map = new LinkedHashMap();
    }

    /**
     * ConnectorMap̐B
     * @param idList IDXg
     * @param props ۑԂ̃vpeB
     */
    public ConnectorMap(List idList, Properties props) {
        this.map = new LinkedHashMap();
        for (int i = 0, n = idList.size(); i < n; i++) {
            String id = (String)idList.get(i);
            Properties p = new Properties();
            copyPropertyById(id, "name", props, p);
            copyPropertyById(id, "driver", props, p);
            copyPropertyById(id, "classpath", props, p);
            copyPropertyById(id, "url", props, p);
            copyPropertyById(id, "user", props, p);
            copyPropertyById(id, "password", props, p);
            copyPropertyById(id, "password.class", props, p);
            copyPropertyById(id, "readonly", props, p);
            copyPropertyById(id, "rollback", props, p);
            Connector connector = new Connector(id, p);
            map.put(id, connector);
        }
    }

    /**
     * ConnectorMap̐(Rs[RXgN^)B
     * @param src Rs[̃CX^X
     */
    public ConnectorMap(ConnectorMap src) {
        this.map = new LinkedHashMap(src.map);
    }

    /**
     * IDƂɃvpeBRs[B
     * @param id ID
     * @param key L[
     * @param src Rs[vpeB
     * @param dst Rs[vpeB
     */
    private void copyPropertyById(String id, String key, Properties src, Properties dst) {
        String fullKey = id + '.' + key;
        String value = src.getProperty(fullKey, StringClass.EMPTY);
        dst.setProperty(key, value);
    }

    /**
     * RlN^̎擾B
     * @param id ID
     * @return RlN^
     */
    public Connector getConnector(String id) {
        return (Connector)get(id);
    }

    /**
     * RlN^̐ݒB
     * @param id ID
     * @param connector RlN^
     */
    public void setConnector(String id, Connector connector) {
        put(id, connector);
    }

    /**
     * vpeBIuWFNg̎擾B
     * @return vpeBIuWFNg
     */
    public Properties toProperties() {
        Properties props = new Properties();
        Object[] idList = map.keySet().toArray();
        for (int i = 0; i < idList.length; i++) {
            String id = (String)idList[i];
            Connector connector = getConnector(id);
            Password password = connector.getPassword();
            props.setProperty(id + ".name", connector.getName());
            props.setProperty(id + ".driver", connector.getDriver());
            props.setProperty(id + ".classpath", connector.getClasspath());
            props.setProperty(id + ".url", connector.getUrl());
            props.setProperty(id + ".user", connector.getUser());
            props.setProperty(id + ".password", password.getTransformedString());
            props.setProperty(id + ".password.class", password.getClass().getName());
            props.setProperty(id + ".readonly", Boolean.toString(connector.isReadOnly()));
            props.setProperty(id + ".rollback", Boolean.toString(connector.usesAutoRollback()));
        }
        return props;
    }

    /* (overridden)
     * @see java.util.AbstractMap#put(java.lang.Object, java.lang.Object)
     */
    public Object put(Object key, Object value) {
        return map.put(key, value);
    }

    /* (overridden)
     * @see java.util.Map#entrySet()
     */
    public Set entrySet() {
        return map.entrySet();
    }

}