package net.argius.stew.gui;

import java.awt.*;

import javax.swing.*;
import javax.swing.table.*;

/**
 * ResultSetTableNulll\TableCellRendererB
 */
final class ResultSetTableNullValueCellRenderer extends DefaultTableCellRenderer {

    static final ResultSetTableNullValueCellRenderer INSTANCE = new ResultSetTableNullValueCellRenderer();

    private static final Color COLOR = new Color(63, 63, 192, 192);

    /**
     * ResultSetTableNullValueCellRenderer̐B
     */
    private ResultSetTableNullValueCellRenderer() {
        // empty
    }

    /* (overridden)
     * @see javax.swing.table.DefaultTableCellRenderer#getTableCellRendererComponent(javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
     */
    public Component getTableCellRendererComponent(JTable table,
                                                   Object value,
                                                   boolean isSelected,
                                                   boolean hasFocus,
                                                   int row,
                                                   int column) {
        Component c = super.getTableCellRendererComponent(table,
                                                          "NULL",
                                                          isSelected,
                                                          hasFocus,
                                                          row,
                                                          column);
        c.setForeground(COLOR);
        Font font = c.getFont();
        int newSize = font.getSize() - 2;
        c.setFont(new Font(font.getFamily(), Font.PLAIN, newSize));
        return c;
    }

}