package net.argius.stew.command;

import java.sql.*;

import net.argius.logging.*;
import net.argius.stew.*;

/**
 * InsertR}hB
 */
public final class Insert extends Command {

    private static final Logger log = LoggerFactory.getLogger(Insert.class);

    /* (overridden)
     * @see net.argius.stew.CommandInterface#execute(java.sql.Connection, net.argius.stew.Parameter)
     */
    public void execute(Connection conn, Parameter parameter) throws CommandException {
        String sql = parameter.getAll();
        if (log.isDebugEnabled()) {
            log.debug("SQL : " + sql);
        }
        try {
            Statement stmt = conn.createStatement();
            try {
                setTimeout(stmt);
                int insertedCount = stmt.executeUpdate(sql);
                Object[] arguments = {new Integer(insertedCount)};
                outputMessage(".inserted", arguments);
            } finally {
                stmt.close();
            }
        } catch (SQLException ex) {
            throw new CommandException(ex);
        }
    }

}