/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.argius.stew.io.CharSequenceFIFO;

final class InputStreamBuffer {
    private final Reader reader;
    private final CharSequenceFIFO fifo;
    private final char[] chars;

    InputStreamBuffer(InputStream inputStream) {
        this.reader = new InputStreamReader(inputStream);
        this.fifo = new CharSequenceFIFO(4096);
        this.chars = new char[1024];
    }

    void close() throws IOException {
        this.reader.close();
    }

    boolean fill(int n) throws IOException {
        int n2;
        while (this.fifo.length() < n && (n2 = this.readChars()) > 0) {
        }
        return this.fifo.length() >= n;
    }

    CharSequence draw() {
        return this.fifo.draw();
    }

    CharSequence draw(int n) {
        return this.fifo.draw(n);
    }

    int readAll() throws IOException {
        int n;
        int n2 = 0;
        while ((n = this.readChars()) >= 0) {
            n2 += n;
        }
        return n2;
    }

    int readChars() throws IOException {
        int n = this.reader.read(this.chars);
        if (n > 0) {
            this.fifo.add(this.chars, 0, n);
        }
        return n;
    }

    int indexOf(char c, int n, boolean bl) throws IOException {
        do {
            int n2;
            if ((n2 = this.fifo.indexOf(c, n)) < 0) continue;
            return n2;
        } while (bl && this.readChars() > 0);
        return -1;
    }

    int indexOf(String string, int n, boolean bl) throws IOException {
        do {
            int n2;
            if ((n2 = this.fifo.indexOf(string, n)) < 0) continue;
            return n2;
        } while (bl && this.readChars() > 0);
        return -1;
    }

    char charAt(int n) {
        return this.fifo.charAt(n);
    }

    int length() {
        return this.fifo.length();
    }
}

