/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTextField;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.gui.DialogMessage;
import net.argius.stew.gui.FormedFont;

public abstract class FlexibleDialogBase
extends JDialog {
    private static final Logger log = LoggerFactory.getLogger(FlexibleDialogBase.class);
    protected GridBagLayout g;
    protected GridBagConstraints c;

    protected FlexibleDialogBase(Frame frame) throws HeadlessException {
        super(frame);
        this.initialize();
    }

    protected FlexibleDialogBase(Dialog dialog) throws HeadlessException {
        super(dialog);
        this.initialize();
    }

    private void initialize() {
        this.setResizable(false);
        this.initializeKeyBind(this);
        this.g = new GridBagLayout();
        this.getContentPane().setLayout(this.g);
        this.c = new GridBagConstraints();
        this.c.gridwidth = 8;
        this.c.fill = 0;
        this.c.ipadx = 2;
        this.c.ipady = 0;
        this.c.insets = new Insets(2, 4, 2, 4);
        this.c.anchor = 17;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
    }

    protected void addComponent(Component component, boolean bl) {
        if (component instanceof JTextField) {
            component.setFont(FormedFont.Large);
        }
        this.initializeKeyBind(component);
        if (bl) {
            this.c.gridwidth = 0;
        }
        this.g.setConstraints(component, this.c);
        this.getContentPane().add(component);
        if (bl) {
            this.c.gridwidth = 21;
        }
    }

    protected JButton createJButton(String string, ActionListener actionListener) {
        JButton jButton = new JButton(string);
        if (actionListener != null) {
            jButton.addActionListener(actionListener);
        }
        return jButton;
    }

    protected final void initializeKeyBind(Component component) {
        component.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    FlexibleDialogBase.this.dispose();
                }
            }
        });
    }

    protected final void onError(Throwable throwable) {
        log.error("", throwable);
        DialogMessage.alert(this, throwable.getMessage());
    }
}

