package net.argius.stew.io;

import java.io.*;
import java.math.*;
import java.util.*;

/**
 * f[^̒/𕶎ōsVACUB
 */
public class StringBasedSerializer {

    /**
     * IuWFNg𒼗񉻂B
     * @param object IuWFNg 
     * @return vf
     * @throws IOException o̓G[ꍇ
     */
    public static Element serialize(Object object) throws IOException {
        String name;
        String value;
        if (object == null) {
            name = Element.NULL;
            value = null;
        } else {
            if (object instanceof String) {
                name = Element.STRING;
                value = (String)object;
            } else if (object instanceof Boolean) {
                name = Element.BOOLEAN;
                value = object.toString();
            } else if (object instanceof Byte) {
                name = Element.BYTE;
                value = object.toString();
            } else if (object instanceof Short) {
                name = Element.SHORT;
                value = object.toString();
            } else if (object instanceof Integer) {
                name = Element.INT;
                value = object.toString();
            } else if (object instanceof Long) {
                name = Element.LONG;
                value = object.toString();
            } else if (object instanceof Float) {
                name = Element.FLOAT;
                value = object.toString();
            } else if (object instanceof Double) {
                name = Element.DOUBLE;
                value = object.toString();
            } else if (object instanceof BigDecimal) {
                name = Element.DECIMAL;
                value = object.toString();
            } else if (object instanceof Date) {
                name = Element.TIME;
                Date date = (Date)object;
                value = Long.toString(date.getTime());
            } else {
                name = Element.OBJECT;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                try {
                    oos.writeObject(object);
                    byte[] bytes = bos.toByteArray();
                    value = toHexString(bytes);
                } finally {
                    oos.close();
                }
            }
        }
        return new Element(name, value);
    }

    /**
     * 񉻂ꂽIuWFNg𕜌B
     * @param name vf
     * @param value l
     * @return ꂽIuWFNg
     * @throws IOException o̓G[ꍇ 
     */
    public static Object deserialize(String name, String value) throws IOException {
        Object o;
        if (name.equals(Element.NULL)) {
            o = null;
        } else if (name.equals(Element.STRING)) {
            o = value;
        } else if (name.equals(Element.BOOLEAN)) {
            o = Boolean.valueOf(value);
        } else if (name.equals(Element.BYTE)) {
            o = Byte.valueOf(value);
        } else if (name.equals(Element.SHORT)) {
            o = Short.valueOf(value);
        } else if (name.equals(Element.INT)) {
            o = Integer.valueOf(value);
        } else if (name.equals(Element.LONG)) {
            o = Long.valueOf(value);
        } else if (name.equals(Element.FLOAT)) {
            o = Float.valueOf(value);
        } else if (name.equals(Element.DOUBLE)) {
            o = Double.valueOf(value);
        } else if (name.equals(Element.DECIMAL)) {
            o = new BigDecimal(value);
        } else if (name.equals(Element.TIME)) {
            o = new Date(Long.parseLong(value));
        } else if (name.equals(Element.OBJECT)) {
            byte[] bytes = toBytes(value);
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            try {
                o = ois.readObject();
            } catch (ClassNotFoundException ex) {
                IOException ioe = new IOException(ex.getMessage());
                ioe.initCause(ex);
                throw ioe;
            } finally {
                ois.close();
            }
        } else {
            throw new IOException("unknown element : " + name);
        }
        return o;
    }

    /**
     * oCgz16iɕϊB
     * @param bytes oCgz
     * @return oCgz16i
     */
    private static String toHexString(byte[] bytes) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < bytes.length; i++) {
            byte b = bytes[i];
            int bit8 = b & 0xFF;
            String hex = Integer.toHexString(bit8).toUpperCase();
            if (bit8 < 0x10) {
                buffer.append('0');
            }
            buffer.append(hex);
        }
        return buffer.toString();
    }

    /**
     * 16ioCgzɕϊB
     * @param hexString 16i
     * @return oCgz
     */
    private static byte[] toBytes(String hexString) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (int i = 0; i < hexString.length(); i += 2) {
            String s = hexString.substring(i, i + 2);
            bos.write(Integer.parseInt(s, 16));
        }
        return bos.toByteArray();
    }

    /**
     * vfB
     */
    public static final class Element {

        /**
         * <code>NULL</code>
         */
        public static final String NULL = "null";
        /**
         * <code>STRING</code>
         */
        public static final String STRING = "string";
        /**
         * <code>BOOLEAN</code>
         */
        public static final String BOOLEAN = "boolean";
        /**
         * <code>BYTE</code>
         */
        public static final String BYTE = "byte";
        /**
         * <code>SHORT</code>
         */
        public static final String SHORT = "short";
        /**
         * <code>INT</code>
         */
        public static final String INT = "int";
        /**
         * <code>LONG</code>
         */
        public static final String LONG = "long";
        /**
         * <code>FLOAT</code>
         */
        public static final String FLOAT = "float";
        /**
         * <code>DOUBLE</code>
         */
        public static final String DOUBLE = "double";
        /**
         * <code>DECIMAL</code>
         */
        public static final String DECIMAL = "decimal";
        /**
         * <code>TIME</code>
         */
        public static final String TIME = "time";
        /**
         * <code>OBJECT</code>
         */
        public static final String OBJECT = "object";

        private final String type;
        private final String value;

        /**
         * Element̐B
         * @param type
         * @param value
         */
        Element(String type, String value) {
            this.type = (type == null) ? NULL : type;
            this.value = value;
        }

        /**
         * vf^Cv̎擾B
         * @return vf^Cv
         */
        public String getType() {
            return type;
        }

        /**
         * value̎擾B
         * @return value
         */
        public String getValue() {
            return value;
        }

        /**
         * ̗vfNULLǂ𒲍B
         * @return ̗vfNULLȂ<code>true</code>AłȂ<code>false</code>
         */
        public boolean isNull() {
            return (type == NULL || value == null);
        }

        /* (overridden)
         * @see java.lang.Object#toString()
         */
        public String toString() {
            return type + ":" + value;
        }

    }

}
