package net.argius.stew.io;

/**
 * V[PXFIFOB
 * 
 * ̃IuWFNg͓ȂB
 */
public final class CharSequenceFIFO implements CharSequence {

    private static final int DEFAULT_CAPACITY = 16;

    private char[] buffer;
    private int limit;

    /**
     * CharSequenceFIFO̐B
     */
    public CharSequenceFIFO() {
        this(DEFAULT_CAPACITY);
    }

    /**
     * CharSequenceFIFO̐B
     * @param capacity eʃTCY
     */
    public CharSequenceFIFO(int capacity) {
        this.buffer = new char[capacity];
        this.limit = 0;
    }

    /* (overridden)
     * @see java.lang.CharSequence#charAt(int)
     */
    public char charAt(int index) {
        checkRange(index);
        return buffer[index];
    }

    /* (overridden)
     * @see java.lang.CharSequence#length()
     */
    public int length() {
        return limit;
    }

    /* (overridden)
     * @see java.lang.CharSequence#subSequence(int, int)
     */
    public CharSequence subSequence(int start, int end) {
        checkRange(end);
        return new String(buffer, start, end - start);
    }

    /**
     * ǉB
     * @param c 
     */
    public void add(char c) {
        ensure(1);
        buffer[limit++] = c;
    }

    /**
     * ǉB
     * @param array 
     */
    public void add(char[] array) {
        add(array, 0, array.length);
    }

    /**
     * ǉB
     * @param array 
     * @param offset ǎ̊Jnʒu
     * @param length ǎ̒
     */
    public void add(char[] array, int offset, int length) {
        ensure(length);
        System.arraycopy(array, offset, buffer, limit, length);
        limit += length;
    }

    /**
     * ǉB
     * @param string 
     */
    public void add(String string) {
        int length = string.length();
        ensure(length);
        string.getChars(0, length, buffer, limit);
        limit += length;
    }

    /**
     * w肵ʒuԂB
     * @param c 
     * @return ʒuBȂꍇ <code>-1</code>
     */
    public int indexOf(char c) {
        return indexOf(c, 0);
    }

    /**
     * w肵ʒuԂB
     * @param c 
     * @param fromIndex Jnʒu
     * @return ʒuBȂꍇ <code>-1</code>
     */
    public int indexOf(char c, int fromIndex) {
        if (fromIndex >= limit) {
            return -1;
        }
        int i = (fromIndex < 0) ? 0 : fromIndex;
        for (; i < limit; i++) {
            if (buffer[i] == c) {
                return i;
            }
        }
        return -1;
    }

    /**
     * w肵񂪌ʒuԂB
     * @param s 
     * @return 񂪌ʒuBȂꍇ <code>-1</code>
     */
    public int indexOf(String s) {
        return indexOf(s, 0);
    }

    /**
     * w肵񂪌ʒuԂB
     * @param s 
     * @param fromIndex Jnʒu
     * @return 񂪌ʒuBȂꍇ <code>-1</code>
     */
    public int indexOf(String s, int fromIndex) {
        final int length = s.length();
        if (length <= 0) {
            return 0;
        }
        final char[] target = s.toCharArray();
        final char initial = target[0];
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (length == 1) {
            return indexOf(initial, fromIndex);
        }
        final int limit = this.limit - length + 1;
        int index = fromIndex;
        loop: while (index < limit) {
            boolean found = false;
            for (int i = index; i < limit; i++) {
                if (buffer[i] == initial) {
                    found = true;
                    index = i;
                    break;
                }
            }
            if (!found) {
                break;
            }
            for (int i = 1; i < length; i++) {
                if (buffer[index + i] != target[i]) {
                    ++index;
                    continue loop;
                }
            }
            return index;
        }
        return -1;
    }

    /**
     * obt@𕥂oB
     * @return V[PX
     */
    public CharSequence draw() {
        return draw(limit);
    }

    /**
     * obt@𕥂oB
     * @param position oʒu
     * @return V[PX
     */
    public CharSequence draw(int position) {
        int length = Math.min(position, limit);
        String subString = new String(buffer, 0, length);
        int capacity = buffer.length;
        System.arraycopy(buffer, position, buffer, 0, capacity - position);
        limit -= position;
        return subString;
    }

    /**
     * obt@\ȗeʂɊgB
     * @param size TCY
     */
    private void ensure(int size) {
        int length = buffer.length;
        if (length > limit + size) {
            return;
        }
        int newsize = length;
        while (newsize < length + size) {
            newsize <<= 1; // TODO TCYg x ^ 2 ͏璷H
        }
        char[] newbuf = new char[newsize];
        System.arraycopy(buffer, 0, newbuf, 0, length);
        buffer = newbuf;
    }

    /**
     * ͈̓`FbNsB
     * @param index CfbNX
     */
    private void checkRange(int index) {
        if (index < 0 || index > limit) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
    }

    /* (overridden)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        CharSequenceFIFO other = (CharSequenceFIFO)obj;
        if (limit != other.limit) {
            return false;
        }
        for (int i = 0; i < limit; i++) {
            if (buffer[i] != other.buffer[i]) {
                return false;
            }
        }
        return true;
    }

    /* (overridden)
     * @see java.lang.Object#hashCode()
     */
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + hashCode(buffer);
        result = prime * result + limit;
        return result;
    }

    /**
     * Returns a hash code value for the array
     * @param array the array to create a hash code value for
     * @return a hash code value for the array
     */
    private static int hashCode(char[] array) {
        int prime = 31;
        int result = 1;
        for (int index = 0; index < array.length; index++) {
            result = prime * result + array[index];
        }
        return result;
    }

    /* (overridden)
     * @see java.lang.CharSequence#toString()
     */
    public String toString() {
        return new String(buffer, 0, limit);
    }

}