package net.argius.stew;

import java.security.*;

import javax.crypto.*;
import javax.crypto.spec.*;

/**
 * PBEɂÍgppX[hB
 */
public final class PbePassword extends CipherPassword {

    private static final String TRANSFORMATION_NAME = "PBEWithMD5AndDES";
    private static final byte[] SALT = "0141STEW".getBytes();
    private static final int ITERATION = 10;

    /* (overridden)
     * @see net.argius.stew.CipherPassword#getCipherInstance(java.lang.String, int)
     */
    protected Cipher getCipherInstance(String code, int mode) {
        try {
            PBEKeySpec keySpec = new PBEKeySpec(code.toCharArray());
            SecretKey key = SecretKeyFactory.getInstance(TRANSFORMATION_NAME)
                                            .generateSecret(keySpec);
            PBEParameterSpec spec = new PBEParameterSpec(SALT, ITERATION);
            Cipher cipher = Cipher.getInstance(TRANSFORMATION_NAME);
            cipher.init(mode, key, spec);
            return cipher;
        } catch (GeneralSecurityException ex) {
            throw new RuntimeException(ex);
        }
    }

}