package net.argius.stew;

import java.io.*;
import java.net.*;
import java.security.*;
import java.util.*;
import java.util.zip.*;

/**
 * I[h@\B
 */
public final class DynamicLoader {

    private static final String CLASSFILE_SUFFIX = ".class";
    private static final int CLASSFILE_SUFFIX_LENGTH = CLASSFILE_SUFFIX.length();

    /**
     * DynamicLoader̐B
     */
    private DynamicLoader() {
        // empty
    }

    /**
     * NX[hB
     * @param className NX(FQCN)
     * @return [hꂽNX
     * @throws DynamicLoadingException I[hO
     */
    public static Class loadClass(String className) throws DynamicLoadingException {
        return loadClass(className, ClassLoader.getSystemClassLoader());
    }

    /**
     * NX[hB
     * @param className NX(FQCN)
     * @param classLoader NX[_
     * @return [hꂽNX
     * @throws DynamicLoadingException I[hO
     */
    public static Class loadClass(String className, ClassLoader classLoader) throws DynamicLoadingException {
        try {
            return classLoader.loadClass(className);
        } catch (Throwable th) {
            throw new DynamicLoadingException("class loading error", th);
        }
    }

    /**
     * VCX^X𐶐B
     * @param className NX(FQCN)
     * @return VCX^X
     * @throws DynamicLoadingException I[hO
     */
    public static Object newInstance(String className) throws DynamicLoadingException {
        ClassLoader classLoader = DynamicLoader.class.getClassLoader();
        return newInstance(className, classLoader);
    }

    /**
     * VCX^X𐶐B
     * @param className NX(FQCN)
     * @param urls NXpXURLz
     * @return  VCX^X
     * @throws DynamicLoadingException I[hO
     */
    public static Object newInstance(String className, URL[] urls) throws DynamicLoadingException {
        return newInstance(className, getURLClassLoader(urls));
    }

    /**
     * VCX^X𐶐B
     * @param className NX(FQCN)
     * @param classLoader NX[_
     * @return VCX^X
     * @throws DynamicLoadingException I[hO
     */
    public static Object newInstance(String className, ClassLoader classLoader) throws DynamicLoadingException {
        return newInstance(loadClass(className, classLoader));
    }

    /**
     * VCX^X𐶐B
     * @param classObject NX
     * @return VCX^X
     * @throws DynamicLoadingException I[hO
     */
    public static Object newInstance(Class classObject) throws DynamicLoadingException {
        try {
            return classObject.newInstance();
        } catch (InstantiationException ex) {
            throw new DynamicLoadingException("load error : " + classObject, ex);
        } catch (IllegalAccessException ex) {
            throw new DynamicLoadingException("load error : " + classObject, ex);
        }
    }

    /**
     * NXz̎擾B
     * @param url NXpXURLz
     * @return NXz
     */
    public static Class[] getClasses(URL url) {
        String path = url.getPath();
        File file = new File(path);
        URLClassLoader classLoader = getURLClassLoader(new URL[]{url});
        if (file.isDirectory()) {
            List classList = new ArrayList();
            findClasses(classList, path.length() + 1, file, classLoader);
            return (Class[])classList.toArray(new Class[classList.size()]);
        } else {
            try {
                ZipInputStream zis = new ZipInputStream(url.openStream());
                try {
                    return getClasses(zis, classLoader);
                } finally {
                    zis.close();
                }
            } catch (IOException ex) {
                throw new DynamicLoadingException("", ex);
            }
        }
    }

    /**
     * NXz̎擾B
     * @param urls NXpXURLz
     * @return NXz
     */
    public static Class[] getClasses(URL[] urls) {
        List list = new ArrayList();
        for (int i = 0; i < urls.length; i++) {
            URL url = urls[i];
            list.addAll(Arrays.asList(getClasses(url)));
        }
        return (Class[])list.toArray(new Class[list.size()]);
    }

    /**
     * URLClassLoader̎擾B
     * @param urls NXpXURLz
     * @return URLClassLoader
     */
    private static URLClassLoader getURLClassLoader(URL[] urls) {
        final URL[] urlArray = urls;
        return (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction() {

            /* (overridden)
             * @see java.security.PrivilegedAction#run()
             */
            public Object run() {
                return new URLClassLoader(urlArray,
                                          ClassLoader.getSystemClassLoader());
            }

        });
    }

    /**
     * NXTB
     * @param classList NXXg
     * @param rootPathLength [gpX̕
     * @param entry t@CorfBNg
     * @param classLoader NX[_
     */
    private static void findClasses(List classList,
                                    int rootPathLength,
                                    File entry,
                                    URLClassLoader classLoader) {
        if (entry.isDirectory()) {
            File[] files = entry.listFiles();
            if (files.length == 0) {
                return;
            }
            for (int i = 0; i < files.length; i++) {
                File file = files[i];
                findClasses(classList, rootPathLength, file, classLoader);
            }
        } else {
            try {
                String path = entry.getAbsolutePath().substring(rootPathLength);
                String fqcn = toClassString(path);
                if (fqcn != null) {
                    classList.add(loadClass(fqcn, classLoader));
                }
            } catch (DynamicLoadingException ex) {
                // ignore
            }
        }
    }

    /**
     * ZIP`t@C̃NXz擾B
     * @param zis ZIP̓Xg[
     * @param classLoader NX[_
     * @return NXz
     * @throws IOException o̓G[ꍇ
     */
    private static Class[] getClasses(ZipInputStream zis,
                                      ClassLoader classLoader) throws IOException {
        List classList = new ArrayList();
        while (zis.available() != 0) {
            ZipEntry entry = zis.getNextEntry();
            if (entry == null) {
                zis.closeEntry();
            } else {
                try {
                    String fqcn = toClassString(entry.getName());
                    if (fqcn != null) {
                        classList.add(loadClass(fqcn, classLoader));
                    }
                } catch (DynamicLoadingException ex) {
                    continue;
                }
            }
        }
        return (Class[])classList.toArray(new Class[classList.size()]);
    }

    /**
     * NXt@C̃pXFQCNɕϊB
     * @param path NXt@C̃pX
     * @return FQCN
     */
    private static String toClassString(String path) {
        if (path != null && path.endsWith(CLASSFILE_SUFFIX)) {
            int lastIndex = path.length() - CLASSFILE_SUFFIX_LENGTH;
            String s = path;
            s = s.replace('/', '.');
            s = s.replace('\\', '.');
            return s.substring(0, lastIndex);
        }
        return null;
    }

    /**
     * w肵NX̃TuNXĎ擾B
     * @param superClass X[p[NX
     * @param urls NXpXURLz
     * @return NXz
     */
    public static Class[] getExtendedClasses(Class superClass, URL[] urls) {
        Class[] classes = getClasses(urls);
        List extendedClassList = new ArrayList();
        for (int i = 0; i < classes.length; i++) {
            Class c = classes[i];
            while (c != null) {
                if (isSame(c, superClass)) {
                    extendedClassList.add(classes[i]);
                    break;
                }
                c = c.getSuperclass();
            }
        }
        return (Class[])extendedClassList.toArray(new Class[extendedClassList.size()]);
    }

    /**
     * w肵C^tF[X̎NXĎ擾B
     * @param interfaceClass C^tF[XNX
     * @param urls NXpXURLz
     * @return w肵C^tF[X̎NXz
     */
    public static Class[] getImplementedClasses(Class interfaceClass, URL[] urls) {
        Class[] classes = getClasses(urls);
        List implementedClassList = new ArrayList();
        for (int i = 0; i < classes.length; i++) {
            Class c = classes[i];
            while (c != null) {
                if (isImplemented(c, interfaceClass)) {
                    implementedClassList.add(classes[i]);
                }
                c = c.getSuperclass();
            }
        }
        return (Class[])implementedClassList.toArray(new Class[implementedClassList.size()]);
    }

    /**
     * NXw肵C^tF[XĂ邩ǂ𒲍B
     * @param target ΏۃNX
     * @param interfaceClass C^tF[X
     * @return NXw肵C^tF[XĂȂ<code>true</code>A
     *         łȂ΁A܂͎w肵C^[tFCXC^tF[XłȂ<code>false</code>
     */
    private static boolean isImplemented(Class target, Class interfaceClass) {
        if (!interfaceClass.isInterface()) {
            return false;
        }
        Class[] interfaceClasses = target.getInterfaces();
        for (int i = 0; i < interfaceClasses.length; i++) {
            if (isSame(interfaceClasses[i], interfaceClass)) {
                return true;
            }
        }
        return false;
    }

    /**
     * NXǂ𒲍B
     * @param class1 NX1
     * @param class2 NX2
     * @return NXȂ<code>true</code>AłȂ<code>false</code>
     */
    private static boolean isSame(Class class1, Class class2) {
        return StringClass.equals(class1, class2);
    }
}