package net.argius.stew;

import java.sql.*;
import java.util.*;

/**
 * RlN^B
 */
final class AnonymousConnector {

    private static final String PREFIX_JDBC = "jdbc:";

    /**
     * AnonymousConnector̐B
     */
    private AnonymousConnector() {
        // empty
    }

    /**
     * RlN^̎擾B
     * @param uri URI
     * @return RlN^B
     */
    public static Connector getConnector(String uri) {
        int index1 = uri.indexOf('@');
        if (index1 < 0) {
            throw new IllegalArgumentException(uri);
        }
        String userInfo = uri.substring(0, index1);
        String url = uri.substring(index1 + 1);
        String user;
        String password;
        int index2 = userInfo.indexOf('/');
        if (index2 >= 0) {
            user = userInfo.substring(0, index2);
            password = userInfo.substring(index2 + 1);
        } else {
            user = userInfo;
            password = "";
        }
        return getConnector(url, user, password);
    }

    /**
     * RlN^̎擾B
     * @param url URL
     * @param user [U
     * @param password pX[h
     * @return RlN^B
     */
    public static Connector getConnector(String url, String user, String password) {
        Properties props = new Properties();
        props.setProperty("name", getName(url, user));
        props.setProperty("driver", getDriver(url));
        props.setProperty("classpath", "./");
        props.setProperty("url", url);
        props.setProperty("user", user);
        props.setProperty("readonly", Boolean.FALSE.toString());
        props.setProperty("rollback", Boolean.FALSE.toString());
        Connector connector = new Connector("", props);
        connector.getPassword().setRowString(password);
        return connector;
    }

    /**
     * RlN^̎擾B
     * @param url URL
     * @param user [U
     * @return RlN^
     */
    private static String getName(String url, String user) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(user);
        buffer.append('@');
        if (url.startsWith(PREFIX_JDBC)) {
            buffer.append(url.substring(PREFIX_JDBC.length()));
        } else {
            buffer.append(url);
        }
        return buffer.toString();
    }

    /**
     * Driver̎擾B
     * @param url URL
     * @return Driver
     */
    private static String getDriver(String url) {
        try {
            Driver driver = DriverManager.getDriver(url);
            return driver.getClass().getName();
        } catch (SQLException ex) {
            System.out.println(ex);
            return "";
        }
    }

}
