package net.argius;

import java.awt.*;

import net.argius.stew.*;
import net.argius.stew.gui.*;
import net.argius.version.*;

/**
 * Stew - "SQL client tool with JDBC"B
 */
public final class Stew {

    /**
     * Stew̐B
     */
    private Stew() {
        // empty
    }

    /**
     * NB
     * @param args s
     */
    private static void invoke(String[] args) {
        final String connectorId = args.length > 0 ? args[0] : "";
        EventQueue.invokeLater(new Runnable() {

            public void run() {
                Environment env = new Environment();
                Launcher launcher;
                if (LocalSystem.containsKey(PropertyKey.LAUNCHER)) {
                    String className = LocalSystem.getProperty(PropertyKey.LAUNCHER);
                    launcher = (Launcher)DynamicLoader.newInstance(className);
                } else {
                    launcher = new StandardInputLauncher();
                }
                if (connectorId.length() > 0) {
                    Command.invoke(env, "-c " + connectorId);
                }
                launcher.launch(env);
            }

        });
    }

    /**
     * AvP[V̋NB
     * @param args s
     */
    public static void main(String[] args) {
        if (args.length > 0) {
            String arg0 = args[0];
            if (arg0.equalsIgnoreCase("-v")) {
                // o[W
                Version version = Version.getInstance(Launcher.class);
                String versionString;
                if (arg0.equals("-V")) {
                    versionString = Constants.PRODUCT_DETAIL_NAME
                                    + ' '
                                    + version.getFullString();
                } else {
                    versionString = Constants.PRODUCT_NAME
                                    + ' '
                                    + version.getRegularString();
                }
                Environment env = new Environment();
                env.getOutputProcessor().output(versionString);
            } else if (arg0.equals("--gui")) {
                // ftHgGUI[h
                WindowLauncher.main(new String[0]);
            } else if (arg0.equals("--edit")) {
                // ڑݒGfB^
                ConnectorMapEditor.main(new String[0]);
            } else if (args.length == 1) {
                // ڑJn + Θb[h
                invoke(args);
            } else {
                // _CNg[h
                String connectorName = arg0;
                StringBuffer buffer = new StringBuffer();
                for (int i = 1; i < args.length; i++) {
                    if (i != 1) {
                        buffer.append(' ');
                    }
                    buffer.append(args[i]);
                }
                String command = buffer.toString();
                Environment env = new Environment();
                Command.invoke(env, "-c " + connectorName);
                Command.invoke(env, command);
                Command.invoke(env, "-d");
            }
        } else {
            // Θb[h
            invoke(args);
        }
    }

}