package net.argius.stew.gui;

import java.awt.*;
import java.io.*;
import java.text.*;

import javax.swing.*;

import net.argius.stew.*;

/**
 * EBhEB
 */
final class Window extends JFrame {

    private Environment env;
    private WindowOutputProcessor op;

    /**
     * Window̐B
     * @param env s
     * @param op WindowOutputProcessor
     */
    Window(Environment env, WindowOutputProcessor op) {
        this.op = op;
        this.env = env;
        setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
        String title = Constants.PRODUCT_NAME;
        int number = op.getSequencialNumber();
        if (number > 1) {
            title += " (" + number + ")";
        }
        setTitle(title);
        setIconImage(new MainIcon().getImage());
    }

    /**
     * ݒ̕B
     */
    void loadConfiguration() {
        try {
            WindowConfiguration.load(this, env.getSystemDirectory());
        } catch (IOException ex) {
            op.onError(ex);
        } catch (RuntimeException ex) {
            String format = Messages.getString("message.configurationfilebroken");
            op.onError(new Exception(MessageFormat.format(format, new String[]{"Window"}), ex));
            WindowConfiguration config = new WindowConfiguration();
            config.apply(this);
        }
    }

    /**
     * ʒu̎擾B
     * @return ʒu
     */
    int getDividerLocation() {
        return op.splitPane.getDividerLocation();
    }

    /**
     * ʒu̐ݒB
     * @param dividerLocation ʒu
     */
    void setDividerLocation(int dividerLocation) {
        op.splitPane.setDividerLocation(dividerLocation);
    }

    /* (overridden)
     * @see java.awt.MenuContainer#getFont()
     */
    public Font getFont() {
        return op.getFont();
    }

    /* (overridden)
     * @see java.awt.Component#setFont(java.awt.Font)
     */
    public void setFont(Font font) {
        op.onFontChanged(font);
    }

    /**
     * Xe[^Xo[\Ԃ̎擾B
     * @return Xe[^Xo[\
     */
    boolean getStatusBarVisibility() {
        return op.statusBarLabel.isVisible();
    }

    /**
     * Xe[^Xo[\Ԃ̐ݒB
     * @param statusBarVisibility Xe[^Xo[\
     */
    void setStatusBarVisibility(boolean statusBarVisibility) {
        op.statusBarLabel.setVisible(statusBarVisibility);
        Menu menu = (Menu)getJMenuBar();
        menu.checkBoxStatusBarVisibility.setSelected(statusBarVisibility);
    }

    /**
     * ׂẴR|[lg̎gp\ݒ肷B
     * @param enable gp\ɂȂ<code>true</code>AłȂ<code>false</code>
     */
    void setAllComponentsEnabled(boolean enable) {
        setAllComponentsEnabled(this, enable);
    }

    /**
     * ReiɊ܂܂邷ׂẴR|[lg̎gp\ݒ肷B
     * @param container Rei
     * @param enable gp\ɂȂ<code>true</code>AłȂ<code>false</code>
     */
    private void setAllComponentsEnabled(Container container, boolean enable) {
        for (int i = 0, n = container.getComponentCount(); i < n; i++) {
            Component component = container.getComponent(i);
            if (component instanceof Container) {
                Container c = (Container)component;
                setAllComponentsEnabled(c, enable);
            }
            component.setEnabled(enable);
        }
    }

    /* (overridden)
     * @see java.awt.Window#dispose()
     */
    public void dispose() {
        try {
            WindowConfiguration.save(this, env.getSystemDirectory());
        } catch (IOException ex) {
            op.onError(ex);
        }
        env = null;
        op = null;
        super.dispose();
    }

}