package net.argius.stew.gui;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.sql.*;
import java.util.*;
import java.util.List;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;

import net.argius.logging.*;
import net.argius.stew.*;
import net.argius.stew.io.*;

/**
 * ʃZbgp̃e[uB
 */
class ResultSetTable extends JTable {

    private static final Logger log = LoggerFactory.getLogger(ResultSetTable.class);

    private final Environment env;
    private final ResultSetTableHeaderCellRenderer headerRenderer;
    private final ResultSetTableRowHeader rowHeader;

    private int limitCount;
    private boolean[] sortedAscArray;
    private String columnAdjustMode;
    private int dragStartColumn;

    /*
     * ZҏWJneditCellAt(int, int, EventObject)Ă΂ꂽꍇA
     * KeyEventߑłȂ߁AOKeyEventۑĎgB
     */
    private volatile KeyEvent lastKeyEvent;

    /**
     * ResultSetTable̐B
     * @param env s
     */
    ResultSetTable(Environment env) {
        this.env = env;
        this.headerRenderer = new ResultSetTableHeaderCellRenderer(getTableHeader().getDefaultRenderer());
        this.rowHeader = new ResultSetTableRowHeader(this);
        this.limitCount = Integer.MAX_VALUE;
        this.sortedAscArray = new boolean[0];
        initialize();
    }

    /**
     * ő\̎擾B
     * @return limitCount ő\
     */
    int getLimitCount() {
        return limitCount;
    }

    /**
     * ő\̐ݒB
     * @param limitCount ő\
     */
    public void setLimitCount(int limitCount) {
        this.limitCount = limitCount;
    }

    /**
     * 񕝒[h̎擾B
     * @return 񕝒[h
     */
    String getColumnAdjustMode() {
        return columnAdjustMode;
    }

    /**
     * 񕝒[h̐ݒB
     * @param columnAdjustMode 񕝒[h
     */
    void setColumnAdjustMode(String columnAdjustMode) {
        this.columnAdjustMode = columnAdjustMode;
    }

    /**
     * B
     */
    private void initialize() {
        ResultSetTableAction.bindAction(this);
        getTableHeader().setDefaultRenderer(headerRenderer);
        JTableHeader header = getTableHeader();
        header.setReorderingAllowed(false);
        ContextMenu contextMenu = new ContextMenu(this);
        addMouseListener(contextMenu);
        header.addMouseListener(contextMenu);
        header.addMouseListener(new MouseAdapter() {

            /* (overridden)
             * @see java.awt.event.MouseAdapter#mousePressed(java.awt.event.MouseEvent)
             */
            public void mousePressed(MouseEvent e) {
                onTableHeaderClicked(e);
            }

        });
        header.addMouseMotionListener(new MouseMotionAdapter() {

            /* (overridden)
             * @see java.awt.event.MouseMotionAdapter#mouseDragged(java.awt.event.MouseEvent)
             */
            public void mouseDragged(MouseEvent e) {
                onTableHeaderClicked(e);
            }

        });
        addKeyListener(new KeyListener() {

            public void keyTyped(KeyEvent e) {
                setLastKeyEvent(e);
            }

            public void keyReleased(KeyEvent e) {
                setLastKeyEvent(e);
            }

            public void keyPressed(KeyEvent e) {
                setLastKeyEvent(e);
            }

        });
    }

    /**
     * lastKeyEvent̐ݒB
     * @param lastKeyEvent lastKeyEvent
     */
    void setLastKeyEvent(KeyEvent lastKeyEvent) {
        this.lastKeyEvent = lastKeyEvent;
    }

    /* (overridden)
     * @see javax.swing.JComponent#setFont(java.awt.Font)
     */
    public void setFont(Font font) {
        super.setFont(font);
        double rate = getSizeRate(font);
        setRowHeight((int)(16 * rate));
        //
        TableColumnModel columnModel = getColumnModel();
        if (columnModel != null && columnModel.getColumnCount() > 0) {
            getTableHeader().setFont(font);
            TableColumn column0 = columnModel.getColumn(0);
            double sizeRate = getSizeRate(getFont()) * 10;
            column0.setPreferredWidth((int)(4 * sizeRate));
        }
    }

    /* (overridden)
     * @see javax.swing.JTable#configureEnclosingScrollPane()
     */
    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
        Container p = getParent();
        if (p instanceof JViewport) {
            Container gp = p.getParent();
            if (gp instanceof JScrollPane) {
                JScrollPane scrollPane = (JScrollPane)gp;
                JViewport viewport = scrollPane.getViewport();
                if (viewport == null || viewport.getView() != this) {
                    return;
                }
                scrollPane.setRowHeaderView(rowHeader);
            }
        }
    }

    /* (overridden)
     * @see javax.swing.JTable#editingStopped(javax.swing.event.ChangeEvent)
     */
    public void editingStopped(ChangeEvent e) {
        Object source = e.getSource();
        if (source instanceof CellEditor) {
            CellEditor editor = (CellEditor)source;
            ResultSetTableModel model = (ResultSetTableModel)getModel();
            if (!model.isInsertRow(getEditingRow())) {
                model.updateCellEdited(this, editor);
            }
            validate();
        }
        super.editingStopped(e);
    }

    /* (overridden)
     * @see javax.swing.JTable#getCellEditor()
     */
    public TableCellEditor getCellEditor() {
        TableCellEditor cellEditor = super.getCellEditor();
        if (cellEditor instanceof DefaultCellEditor) {
            DefaultCellEditor d = (DefaultCellEditor)cellEditor;
            Component component = d.getComponent();
            if (component != null) {
                if (!component.isEnabled()) {
                    log.warn("forced to enable CellEditor");
                    component.setEnabled(true);
                }
                component.setFont(getFont());
                component.setBackground(Color.PINK);
            }
        }
        return cellEditor;
    }

    /* (overridden)
     * @see javax.swing.JTable#getCellRenderer(int, int)
     */
    public TableCellRenderer getCellRenderer(int row, int column) {
        if (getValueAt(row, column) != null) {
            return super.getCellRenderer(row, column);
        } else {
            return ResultSetTableNullValueCellRenderer.INSTANCE;
        }
    }

    /* (overridden)
     * @see javax.swing.JTable#editCellAt(int, int, java.util.EventObject)
     */
    public boolean editCellAt(int row, int column, EventObject e) {
        boolean succeeded = super.editCellAt(row, column, e);
        if (succeeded) {
            if (editorComp instanceof JTextField) {
                // #208: ZҏW[hŒlIԂɂ
                if (lastKeyEvent != null && lastKeyEvent.getKeyCode() != KeyEvent.VK_F2) {
                    JTextField editor = (JTextField)editorComp;
                    editor.selectAll();
                }
            }
        }
        return succeeded;
    }

    /**
     * TCY{̎擾B
     * @param font ƂȂtHg
     * @return TCY{
     */
    private double getSizeRate(Font font) {
        return font.getSize() / 1d / FormedFont.Regular.getSize();
    }

    /**
     * ԍ\Ԃ̎擾B
     * @return ԍ\
     */
    boolean isShowColumnNumber() {
        return headerRenderer.isShowNumber();
    }

    /**
     * ԍ\Ԃ̐ݒB
     * @param isShowColumnNumber ԍ\
     */
    void setShowColumnNumber(boolean isShowColumnNumber) {
        headerRenderer.setShowNumber(isShowColumnNumber);
    }

    /**
     * e[uwb_}EXNbNꂽ̃CxgB
     * @param e }EXCxg
     */
    final void onTableHeaderClicked(MouseEvent e) {
        if (getRowCount() == 0) {
            return;
        }
        Point p = new Point(e.getX(), e.getY());
        if (SwingUtilities.isLeftMouseButton(e)) {
            int id = e.getID();
            boolean isMousePressed = id == MouseEvent.MOUSE_PRESSED;
            boolean isMouseDragged = id == MouseEvent.MOUSE_DRAGGED;
            if (isMousePressed || isMouseDragged) {
                if (!e.isControlDown() && !e.isShiftDown()) {
                    clearSelection();
                }
                int columnIndex = columnAtPoint(p);
                if (columnIndex < 0 || getColumnCount() <= columnIndex) {
                    return;
                }
                int index0;
                int index1;
                if (isMousePressed) {
                    if (e.isShiftDown()) {
                        index0 = dragStartColumn;
                        index1 = columnIndex;
                    } else {
                        dragStartColumn = columnIndex;
                        index0 = columnIndex;
                        index1 = columnIndex;
                    }
                } else if (isMouseDragged) {
                    index0 = dragStartColumn;
                    index1 = columnIndex;
                } else {
                    return;
                }
                selectColumn(index0, index1);
                requestFocus();
            }
        }
    }

    /**
     * IB
     * @param columnIndex CfbNX
     * @deprecated selectColumn(int, int) gpĂB
     */
    void selectColumn(int columnIndex) {
        selectColumn(columnIndex, columnIndex);
    }

    /**
     * IB
     * @param index0 JnCfbNX
     * @param index1 ICfbNX
     */
    void selectColumn(int index0, int index1) {
        if (getRowCount() > 0) {
            addColumnSelectionInterval(index0, index1);
            addRowSelectionInterval(getRowCount() - 1, 0);
        }
    }

    /**
     * 0(ō)̕B
     * @deprecated sԍ\ ResultSetTableRowHeader ɒu܂B̃\bh͉܂B
     */
    void fitColumn0() {
        // do nothing
    }

    /**
     * e[u}EXNbNꂽ̃CxgB
     * @param e }EXCxg
     * @deprecated sԍ\ ResultSetTableRowHeader ɒu܂B̃\bh͉܂B
     */
    final void onTableClicked(MouseEvent e) {
        // do nothing
    }

    /**
     * \[gs˗B
     * @param clickedIndex Iꂽ
     */
    void requestSort(int clickedIndex) {
        if (clickedIndex > 0) {
            final int threshold = 2000;
            int rate = getRowCount() * (1 + getColumnCount() / 10);
            if (rate >= threshold) {
                final String message = Messages.getString("window.ResultSetTable.sort.confirm");
                int result = DialogMessage.confirmYesNo(getParent(), message);
                if (result != JOptionPane.OK_OPTION) {
                    return;
                }
            }
        }
        sort(clickedIndex);
    }

    /**
     * \[gB
     * }\[gASYgpB
     * @param clickedIndex Iꂽ
     */
    private void sort(int clickedIndex) {
        int rows = getRowCount();
        int cols = getColumnCount();
        boolean sortedAsc = sortedAscArray[clickedIndex];
        Comparator cmp = new ResultSetValueComparator();
        for (int i = 1; i < rows; i++) {
            for (int j = i; j > 0; j--) {
                Object v1 = getValueAt(j - 1, clickedIndex);
                Object v2 = getValueAt(j, clickedIndex);
                if (cmp.compare(v1, v2) > 0 == sortedAsc) {
                    break;
                }
                swap(j, j - 1);
            }
        }
        for (int i = 0; i < cols; i++) {
            sortedAscArray[i] = false;
        }
        sortedAscArray[clickedIndex] = !sortedAsc;
    }

    /**
     * lB
     * @param rowIndex1 sCfbNX1
     * @param rowIndex2 sCfbNX1
     */
    private void swap(int rowIndex1, int rowIndex2) {
        int cols = getColumnCount();
        for (int i = 0; i < cols; i++) {
            Object o = getValueAt(rowIndex1, i);
            setValueAt(getValueAt(rowIndex2, i), rowIndex1, i);
            setValueAt(o, rowIndex2, i);
        }
    }

    /**
     * 񕝂ύXB
     * @param rate {
     */
    void changeColumnWidth(double rate) {
        TableColumnModel columnModel = getColumnModel();
        for (int i = 0, n = getColumnCount(); i < n; i++) {
            TableColumn column = columnModel.getColumn(i);
            int newWidth = (int)(column.getWidth() * rate);
            column.setPreferredWidth(newWidth);
        }
    }

    /**
     * 񕝂̎sB
     */
    void adjustColumnWidth() {
        if (columnAdjustMode == null) {
            return;
        }
        if (columnAdjustMode.equalsIgnoreCase("header")) {
            // wb_̕ɂ钲
            int fontSize = getFont().getSize();
            TableColumnModel columnModel = getColumnModel();
            for (int columnIndex = 0, n = getColumnCount(); columnIndex < n; columnIndex++) {
                TableColumn column = columnModel.getColumn(columnIndex);
                String headerName = String.valueOf(column.getHeaderValue());
                int size = (headerName.length() + 1) * fontSize;
                column.setPreferredWidth(size);
            }
        } else if (columnAdjustMode.equalsIgnoreCase("value")) {
            // l̕ɂ钲
            int rowCount = getRowCount();
            if (rowCount == 0) {
                return;
            }
            int fontSize = getFont().getSize();
            TableColumnModel columnModel = getColumnModel();
            JTableHeader header = getTableHeader();
            for (int columnIndex = 0, n = getColumnCount(); columnIndex < n; columnIndex++) {
                TableColumn column = columnModel.getColumn(columnIndex);
                TableCellRenderer headerRenderer = column.getHeaderRenderer();
                if (headerRenderer == null) {
                    headerRenderer = header.getDefaultRenderer();
                }
                int size = 1;
                if (headerRenderer != null) {
                    size = headerRenderer.getTableCellRendererComponent(this,
                                                                        getValueAt(0, columnIndex),
                                                                        false,
                                                                        false,
                                                                        0,
                                                                        columnIndex)
                                         .getPreferredSize().width;
                }
                for (int rowIndex = 0; rowIndex < rowCount; rowIndex++) {
                    TableCellRenderer renderer = getCellRenderer(rowIndex, columnIndex);
                    Object value = getValueAt(rowIndex, columnIndex);
                    Component component = renderer.getTableCellRendererComponent(this,
                                                                                 value,
                                                                                 false,
                                                                                 false,
                                                                                 rowIndex,
                                                                                 columnIndex);
                    size = Math.max(size, component.getPreferredSize().width / 2);
                    if (value instanceof java.util.Date) {
                        size *= 2;
                        if (log.isDebugEnabled()) {
                            log.debug("[" + columnIndex + "] size = " + size);
                        }
                        break;
                    }
                }
                size = (int)(size * 1D / fontSize * 14);
                columnModel.getColumn(columnIndex).setPreferredWidth(size);
            }
        }
    }

    /**
     * et@Cɏo͂B
     * @param file t@C
     * @throws IOException o̓G[ꍇ
     */
    void export(File file) throws IOException {
        Exporter exporter = Exporter.getExporter(file);
        try {
            int columnCount = getColumnCount();
            int rowCount = getRowCount();
            DefaultTableModel model = (DefaultTableModel)getModel();
            List data = model.getDataVector();
            for (int rowIndex = 0; rowIndex < rowCount; rowIndex++) {
                List row = (List)data.get(rowIndex);
                exporter.addRow(row.subList(1, columnCount).toArray());
            }
        } finally {
            exporter.close();
        }
    }

    /**
     * ʃZbgo͂B
     * @param rs ʃZbg
     * @param order 
     * @param cmd R}h
     * @return ʂ̌
     * @throws SQLException SQL֘AG[ꍇ
     */
    int outputResultSet(ResultSet rs, ColumnOrder order, String cmd) throws SQLException {

        /*
         * ͔̏AWTXbhs邽
         * GUȈEventDispatchThreadsĂ
         */

        // \̍XV(O)
        final JTableHeader header = this.tableHeader;
        final DefaultTableModel rowHeaderModel = (DefaultTableModel)rowHeader.getModel();
        EventQueue.invokeLater(new Runnable() {

            public void run() {
                setVisible(false);
                header.setVisible(false);
                rowHeaderModel.setRowCount(0);
            }

        });

        // f[^f
        boolean needOrderChange = order.size() > 0;
        ResultSetMetaData rsmeta = rs.getMetaData();
        int cols;
        int[] types;
        if (needOrderChange) {
            cols = order.size();
            types = new int[cols];
            for (int i = 0; i < cols; i++) {
                int index = order.getOrder(i);
                types[i] = rsmeta.getColumnType(index);
            }
        } else {
            cols = order.size();
            cols = rsmeta.getColumnCount();
            types = new int[cols];
            for (int i = 0; i < cols; i++) {
                types[i] = rsmeta.getColumnType(i + 1);
            }
        }
        ResultSetTableMonitor monitor = new ResultSetTableMonitor();
        final ResultSetTableModel model = new ResultSetTableModel(cols, types, monitor, rowHeader);

        // [vJn
        int rowCount = 0;
        for (; rs.next(); rowCount++) {
            if (rowCount >= limitCount) {
                break;
            }
            Vector row = new Vector();
            for (int i = 0; i < cols; i++) {
                int index;
                if (needOrderChange) {
                    index = order.getOrder(i);
                } else {
                    index = i + 1;
                }
                row.add(rs.getObject(index));
            }
            model.addRow(row);
        }

        // wb_\l
        final String[] headerValues = new String[cols];
        for (int i = 0; i < cols; i++) {
            String columnName;
            if (needOrderChange) {
                columnName = order.getName(i);
            } else {
                columnName = rsmeta.getColumnName(i + 1);
            }
            headerValues[i] = columnName;
        }

        // I
        sortedAscArray = new boolean[cols];
        if (!env.getCurrentConnector().isReadOnly()) {
            monitor.prepare(rs, cmd);
        }

        // \̍XV()
        EventQueue.invokeLater(new Runnable() {

            public void run() {
                setModel(model);
                int columnCount = getColumnCount();
                TableColumnModel columnModel = getColumnModel();
                for (int i = 0; i < columnCount; i++) {
                    TableColumn column = columnModel.getColumn(i);
                    column.setHeaderValue(headerValues[i]);
                }
                adjustColumnWidth();
                model.addTableModelListener(ResultSetTable.this);
                setUpdatableSign();
                validate();
                header.setVisible(true);
                setVisible(true);
            }

            /**
             * XVۃTC̐ݒB
             */
            private void setUpdatableSign() {
                Container p = getParent();
                if (p != null && p.getParent() instanceof JScrollPane) {
                    JScrollPane scrollPane = (JScrollPane)p.getParent();
                    String iconResource = "icon.updatable." + model.isUpdatable() + ".gif";
                    scrollPane.setCorner(ScrollPaneConstants.UPPER_LEFT_CORNER,
                                         new JLabel(new ImageIcon(getClass().getResource(iconResource)),
                                                    SwingConstants.CENTER));
                }
            }

        });

        return rowCount;
    }

}