package net.argius.stew.gui;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;
import java.util.*;

import javax.swing.*;

/**
 * wv\ANVB
 */
public final class HelpInfoAction extends AbstractAction {

    private final Container parent;

    /**
     * HelpInfoAction̐B
     * @param parent eR|[lg
     */
    public HelpInfoAction(Container parent) {
        this.parent = parent;
    }

    /* (overridden)
     * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
     */
    public void actionPerformed(ActionEvent e) {
        try {
            String language = Locale.getDefault().getLanguage();
            File file = new File("MANUAL_" + language);
            showEditorPane(parent, file);
        } catch (IOException ex) {
            DialogMessage.alert(parent, ex.getMessage());
        } catch (RuntimeException ex) {
            DialogMessage.alert(parent, ex.getMessage());
        }
    }

    /**
     * EditorPane̕\B
     * @param parent eR|[lg
     * @param file wvt@C
     * @throws IOException o̓G[ꍇ
     */
    private static void showEditorPane(Container parent, File file) throws IOException {
        try {
            URL url = file.toURL();
            JEditorPane ep = new JEditorPane(url);
            ep.setEditable(false);
            JScrollPane sp = new JScrollPane(ep);
            JOptionPane pane = new JOptionPane(sp,
                                               JOptionPane.PLAIN_MESSAGE,
                                               JOptionPane.DEFAULT_OPTION);
            JDialog dialog = pane.createDialog(parent, "HELP");
            Point p = parent.getLocation();
            p.x += 10;
            p.y += 10;
            dialog.setLocation(p);
            Dimension d = parent.getSize();
            d.width *= 0.8;
            d.height *= 0.8;
            dialog.setSize(d);
            dialog.setVisible(true);
        } catch (MalformedURLException ex) {
            IOException ioe = new IOException();
            ioe.initCause(ex);
            throw ioe;
        }
    }

}