package net.argius.stew.gui;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.util.List;

import javax.swing.*;
import javax.swing.event.*;

/**
 * tHgI@\B
 */
public final class FontChooser {

    private static final Font DEFAULT = FormedFont.Regular;
    private static final Object[] FAMILIES = {"Sans-Serif", "Serif",
                                              "Monospaced",};

    private final List listeners;
    private final JComboBox tFamily;
    private final JSpinner sSize;
    private final JTextField tSample;

    private FlexibleDialogBase dialog;
    private Font currentFont;

    /**
     * FontChooser̐B
     * @throws HeadlessException
     */
    public FontChooser() throws HeadlessException {
        this.currentFont = DEFAULT;
        this.listeners = new ArrayList();
        this.tFamily = new JComboBox(FAMILIES);
        int fontSize = currentFont.getSize();
        this.sSize = new JSpinner(new SpinnerNumberModel(fontSize, 6, 32, 1));
        this.tSample = new JTextField(getMessage("sample"));
        tFamily.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                onValueChanged(e);
            }

        });
        sSize.addChangeListener(new ChangeListener() {

            public void stateChanged(ChangeEvent e) {
                onValueChanged(e);
            }

        });
    }

    /**
     * currentFont̎擾B
     * @return currentFont
     */
    public Font getCurrentFont() {
        return currentFont;
    }

    /**
     * currentFont̐ݒB
     * @param currentFont currentFont
     */
    public void setCurrentFont(Font currentFont) {
        this.currentFont = currentFont;
    }

    /**
     * _CAO\B
     * @param owner et[
     */
    void showDialog(Frame owner) {
        String fontFamily = currentFont.getFamily();
        int fontSize = currentFont.getSize();

        dialog = new FlexibleDialogBase(owner) {
            // empty
        };
        tFamily.setEditable(true);
        tFamily.setSelectedItem(fontFamily);
        dialog.addComponent(tFamily, false);

        sSize.setValue(new Integer(fontSize));
        dialog.addComponent(sSize, true);

        dialog.addComponent(tSample, true);
        tSample.setFont(currentFont);
        tSample.updateUI();

        JButton submit = new JButton(getMessage("submit"));
        submit.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                onButtonSubmitClicked();
            }

        });
        dialog.addComponent(submit, false);

        JButton reset = new JButton(getMessage("reset"));
        reset.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                onButtonResetClicked();
            }

        });
        dialog.addComponent(reset, false);

        dialog.pack();
        dialog.setLocationRelativeTo(owner);
        dialog.setVisible(true);
    }

    /**
     * ύXXi̒ǉB
     * @param listener Xi
     */
    public void addChangeListener(ChangeListener listener) {
        listeners.add(listener);
    }

    /**
     * ύXXi̍폜B
     * @param listener Xi
     */
    public void removeChangeListener(ChangeListener listener) {
        listeners.remove(listener);
    }

    /**
     * tHgύXCxg̒ʒmB
     */
    protected void fireFontChanged() {
        currentFont = tSample.getFont();
        ChangeEvent e = new ChangeEvent(currentFont);
        for (int i = 0, n = listeners.size(); i < n; i++) {
            ChangeListener listener = (ChangeListener)listeners.get(i);
            listener.stateChanged(e);
        }
    }

    /**
     * lύXꂽƂ̏B
     * @param e Cxg
     */
    void onValueChanged(EventObject e) {
        String familyName = String.valueOf(tFamily.getSelectedItem());
        int size;
        Object value = sSize.getValue();
        if (value instanceof Integer) {
            Integer i = (Integer)value;
            size = i.intValue();
        } else {
            size = currentFont.getSize();
        }
        Font f = new Font(familyName, Font.PLAIN, size);
        tSample.setFont(f);
        dialog.pack();
    }

    /**
     * {^"SUBMIT"ꂽƂ̏B
     */
    void onButtonSubmitClicked() {
        fireFontChanged();
        dialog.dispose();
        dialog = null;
    }

    /**
     * {^"RESET"ꂽƂ̏B
     */
    void onButtonResetClicked() {
        Font font = DEFAULT;
        tFamily.setSelectedItem(font.getFamily());
        sSize.setValue(new Integer(font.getSize()));
        onValueChanged(new ChangeEvent(font));
    }

    /**
     * (O)bZ[W̎擾B
     * @param key L[
     * @return bZ[W
     */
    private static String getMessage(String key) {
        return Messages.getString("dialog.FontChooser." + key);
    }

}