package net.argius.stew.gui;

import java.awt.event.*;

import javax.swing.*;
import javax.swing.text.*;

import net.argius.stew.*;

/**
 * [^CvTextAreaB
 */
final class ConsoleTextArea extends JTextArea {

    private final WindowOutputProcessor op;
    private final HistoryList historyList;

    private int borderPosition;

    /**
     * ConsoleTextArea̐B
     * @param op WindowOutputProcessor
     */
    ConsoleTextArea(WindowOutputProcessor op) {
        this.op = op;
        this.historyList = new HistoryList();
        initializeView();
        initializeKeyBind();
        AbstractDocument document = (AbstractDocument)getDocument();
        document.setDocumentFilter(new PrivateDocumentFilter(this));
        validate();
    }

    /**
     * OςB
     */
    private void initializeView() {
        setLineWrap(true);
        setWrapStyleWord(false);
    }

    /**
     * L[oCh̏B
     */
    private void initializeKeyBind() {
        final InputMap imap = getInputMap();
        // ENTER
        imap.put(getKeyStroke(KeyEvent.VK_ENTER), new AbstractAction() {

            public void actionPerformed(ActionEvent e) {
                sendCommand();
            }

        });
        // HOME
        imap.put(getKeyStroke(KeyEvent.VK_HOME), new AbstractAction() {

            public void actionPerformed(ActionEvent e) {
                setCaretPosition(getBorderPosition());
            }

        });
        // Ctrl+C without Selected (BREAK)
        imap.put(KeyStroke.getKeyStroke(KeyEvent.VK_C, InputEvent.CTRL_DOWN_MASK),
                 new AbstractAction() {

                     public void actionPerformed(ActionEvent e) {
                         if (getSelectedText() == null) {
                             onBreak();
                         } else {
                             Action copyAction = new DefaultEditorKit.CopyAction();
                             copyAction.actionPerformed(e);
                         }
                     }

                 });
        // Alt+B (BREAK)
        imap.put(KeyStroke.getKeyStroke(KeyEvent.VK_B, InputEvent.ALT_DOWN_MASK),
                 new AbstractAction() {

                     public void actionPerformed(ActionEvent e) {
                         onBreak();
                     }

                 });
        // Ctrl+ENTER (input NewLine)
        imap.put(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, InputEvent.CTRL_DOWN_MASK),
                 new AbstractAction() {

                     private final String lineSeparator = System.getProperty("line.separator");

                     public void actionPerformed(ActionEvent e) {
                         insert(lineSeparator, getCaretPosition());
                     }

                 });
    }

    /**
     * R}h͒f̏B
     */
    void onBreak() {
        append(" [BREAK]> ");
        borderPosition = getCursorEndPosition();
        validate();
    }

    /* (overridden)
     * @see java.awt.Container#validate()
     */
    public void validate() {
        super.validate();
        int lastPosition = getCursorEndPosition();
        getCaret().setDot(lastPosition);
    }

    /**
     * Eʒu̎擾B
     * @return Eʒu
     */
    int getBorderPosition() {
        return borderPosition;
    }

    /**
     * w肵ʒuҏW\ǂ𒲍B
     * @param position ʒu
     * @return w肵ʒuҏW\Ȃ<code>true</code>AłȂ<code>false</code>
     */
    boolean isEditablePosition(int position) {
        return (position >= borderPosition);
    }

    /**
     * R}h̑MB
     */
    void sendCommand() {
        try {
            synchronized (this) {
                Document doc = getDocument();
                int cp = getCaretPosition();
                int ep = getCursorEndPosition();
                if (cp != ep) {
                    setCaretPosition(ep);
                    return;
                }
                String input = doc.getText(borderPosition, ep - borderPosition);
                op.requestCommand(input);
                if (!StringClass.isBlank(input)) {
                    historyList.add(input);
                }
                borderPosition = getCursorEndPosition();
            }
        } catch (BadLocationException ex) {
            op.onError(ex);
        }
    }

    /* (overridden)
     * @see javax.swing.JTextArea#append(java.lang.String)
     */
    public void append(String string) {
        int length = string.length();
        super.append(string);
        borderPosition += length;
        setCaretPosition(getCursorEndPosition());
    }

    /**
     * bZ[W̖m͈͂uB
     * m͈͂Ƃ́Avvg烁bZ[W̖܂ł̂ƁB
     * @param string u镶
     */
    void replace(String string) {
        replaceRange(string, borderPosition, getCursorEndPosition());
    }

    /**
     * bZ[WNAB
     */
    void clear() {
        borderPosition = 0;
        setText(StringClass.EMPTY);
    }

    /**
     * ЂƂkB
     */
    void turnBackHistory() {
        String history = historyList.getPrevious();
        if (!StringClass.isEmpty(history)) {
            replace(history);
        }
    }

    /**
     * ЂƂiށB
     */
    void turnNextHistory() {
        String history = historyList.getNext();
        if (!StringClass.isEmpty(history)) {
            replace(history);
        }
    }

    /**
     * L[Xg[N̎擾B
     * @param keyCode L[萔(KeyEvent)
     * @return L[Xg[N
     */
    private KeyStroke getKeyStroke(int keyCode) {
        return KeyStroke.getKeyStroke(keyCode, 0);
    }

    /**
     * ʒuiJ[\j̎擾B
     * @return ʒu
     */
    private int getCursorEndPosition() {
        Document document = getDocument();
        Position position = document.getEndPosition();
        return position.getOffset() - 1;
    }

    /**
     * ConsoleTextAreâ߂̃hLgtB^B
     */
    private static final class PrivateDocumentFilter extends DocumentFilter {

        private final ConsoleTextArea consoleTextArea;

        /**
         * ConsoleDocumentFilter̐B
         * @param consoleTextArea
         */
        PrivateDocumentFilter(ConsoleTextArea consoleTextArea) {
            this.consoleTextArea = consoleTextArea;
        }

        /* (overridden)
         * @see javax.swing.text.DocumentFilter#insertString(javax.swing.text.DocumentFilter.FilterBypass, int, java.lang.String, javax.swing.text.AttributeSet)
         */
        public void insertString(FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            if (consoleTextArea.isEditablePosition(offset)) {
                super.insertString(fb, offset, string, attr);
            }
        }

        /* (overridden)
         * @see javax.swing.text.DocumentFilter#remove(javax.swing.text.DocumentFilter.FilterBypass, int, int)
         */
        public void remove(FilterBypass fb, int offset, int length) throws BadLocationException {
            if (consoleTextArea.isEditablePosition(offset)) {
                super.remove(fb, offset, length);
            }
        }

        /* (overridden)
         * @see javax.swing.text.DocumentFilter#replace(javax.swing.text.DocumentFilter.FilterBypass, int, int, java.lang.String, javax.swing.text.AttributeSet)
         */
        public void replace(FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (consoleTextArea.isEditablePosition(offset)) {
                super.replace(fb, offset, length, text, attrs);
            }
        }

    }

}