package net.argius.stew.gui;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import java.util.List;

import javax.swing.*;
import javax.swing.event.*;

import net.argius.stew.*;

/**
 * ڑݒҏW_CAOB
 */
final class ConnectorMapEditDialog extends FlexibleDialogBase implements ChangeListener {

    private final JList idList;
    private final ConnectorMap connectorMap;

    /**
     * ConnectorMapEditDialog̐B
     * @param owner Ăяot[
     * @param env s
     */
    ConnectorMapEditDialog(JFrame owner, Environment env) {
        super(owner);
        this.connectorMap = new ConnectorMap(env.getConnectorMap());

        // Dialog
        setTitle(getMessage("title"));
        initializeKeyBind(this);
        c.anchor = GridBagConstraints.CENTER;
        c.insets = new Insets(8, 12, 8, 0);

        // List
        idList = new JList();
        idList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        initializeKeyBind(idList);
        idList.setListData(connectorMap.keySet().toArray());
        JScrollPane pane = new JScrollPane(idList);
        pane.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        idList.addMouseListener(new MouseAdapter() {

            public void mouseClicked(MouseEvent e) {
                int clickCount = e.getClickCount();
                if (clickCount % 2 == 0) {
                    onListDoubleClicked();
                }
            }

        });
        c.gridwidth = 3;
        c.fill = GridBagConstraints.BOTH;
        addComponent(pane, false);

        // Button 1
        JPanel p1 = new JPanel(new GridLayout(5, 1, 4, 2));
        JButton buttonNew = createJButton(getMessage("button.addnew"), new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                onButtonNewClicked();
            }

        });
        p1.add(buttonNew);
        JButton buttonModify = createJButton(getMessage("button.modify"), new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                onButtonModifyClicked();
            }

        });
        p1.add(buttonModify);
        JButton buttonRemove = createJButton(getMessage("button.remove"), new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                onButtonRemoveClicked();
            }

        });
        p1.add(buttonRemove);
        JButton buttonUp = createJButton(getMessage("button.up"), new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                onButtonUpClicked();
            }

        });
        p1.add(buttonUp);
        JButton buttonDown = createJButton(getMessage("button.down"), new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                onButtonDownClicked();
            }

        });
        p1.add(buttonDown);
        c.gridwidth = GridBagConstraints.REMAINDER;
        c.insets = new Insets(8, 32, 8, 32);
        addComponent(p1, true);

        // Button 2
        JPanel p2 = new JPanel(new GridLayout(1, 2, 16, 8));
        JButton buttonSubmit = createJButton(getMessage("button.submit"), new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                onButtonSubmitClicked();
            }

        });
        p2.add(buttonSubmit);
        JButton buttonCancel = createJButton(getMessage("button.cancel"), new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                onButtonCancelClicked();
            }

        });
        p2.add(buttonCancel);
        c.gridwidth = GridBagConstraints.REMAINDER;
        c.fill = GridBagConstraints.NONE;
        addComponent(p2, false);
    }

    /* (overridden)
     * @see javax.swing.event.ChangeListener#stateChanged(javax.swing.event.ChangeEvent)
     */
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source instanceof Connector) {
            Connector connector = (Connector)source;
            String id = connector.getId();
            connectorMap.setConnector(id, connector);
            updateList();
        }
    }

    /**
     * XgŐV̏ԂɂB
     */
    private void updateList() {
        List newList = new ArrayList();
        List oldList = Arrays.asList(getElements());
        for (Iterator it = connectorMap.keySet().iterator(); it.hasNext();) {
            Object element = it.next();
            if (!oldList.contains(element)) {
                newList.add(element);
            }
        }
        for (int i = 0, n = oldList.size(); i < n; i++) {
            Object element = oldList.get(i);
            if (connectorMap.containsKey(element)) {
                newList.add(element);
            }
        }
        idList.setListData(newList.toArray());
    }

    /**
     * vf̔z擾B
     * @return vf̔z
     */
    private Object[] getElements() {
        List list = new ArrayList();
        ListModel model = idList.getModel();
        for (int i = 0, n = model.getSize(); i < n; i++) {
            list.add(model.getElementAt(i));
        }
        return list.toArray();
    }

    /**
     * RlN^ҏW_CAOJB
     * @param connector ҏWΏۃRlN^
     */
    private void openConnectorEditDialog(Connector connector) {
        ConnectorEditDialog dialog = new ConnectorEditDialog(this, connector);
        dialog.addChangeListener(this);
        dialog.setModal(true);
        dialog.setLocationRelativeTo(getParent());
        dialog.setSize(dialog.getPreferredSize());
        dialog.setVisible(true);
    }

    /**
     * Xg̃_uNbN̏B
     */
    void onListDoubleClicked() {
        onButtonModifyClicked();
    }

    /**
     * "VK"{^̏B
     */
    void onButtonNewClicked() {
        Connector connector = new Connector(StringClass.EMPTY, new Properties());
        openConnectorEditDialog(connector);
    }

    /**
     * "ύX"{^̏B
     */
    void onButtonModifyClicked() {
        Object value = idList.getSelectedValue();
        if (value instanceof String) {
            String id = (String)value;
            Connector connector = connectorMap.getConnector(id);
            openConnectorEditDialog(connector);
        }
    }

    /**
     * "폜"{^̏B
     */
    void onButtonRemoveClicked() {
        Object selected = idList.getSelectedValue();
        connectorMap.remove(selected);
        updateList();
    }

    /**
     * ""{^̏B
     */
    void onButtonUpClicked() {
        int index = idList.getSelectedIndex();
        if (index > 0) {
            Object[] array = getElements();
            Object o = array[index];
            array[index] = array[index - 1];
            array[index - 1] = o;
            idList.setListData(array);
            idList.setSelectedIndex(index - 1);
        }
    }

    /**
     * ""{^̏B
     */
    void onButtonDownClicked() {
        int index = idList.getSelectedIndex();
        int size = idList.getModel().getSize();
        if (index < size - 1) {
            Object[] array = getElements();
            Object o = array[index];
            array[index] = array[index + 1];
            array[index + 1] = o;
            idList.setListData(array);
            idList.setSelectedIndex(index + 1);
        }
    }

    /**
     * ""{^̏B
     */
    void onButtonSubmitClicked() {
        int result = DialogMessage.confirmYesNo(this, getMessage("confirm.save"));
        if (result != JOptionPane.YES_OPTION) {
            return;
        }
        ConnectorMap m = new ConnectorMap();
        Object[] elements = getElements();
        for (int i = 0; i < elements.length; i++) {
            String id = (String)elements[i];
            m.setConnector(id, connectorMap.getConnector(id));
        }
        try {
            ConnectorConfiguration.save(m);
            connectorMap.clear();
            connectorMap.putAll(m);
        } catch (IOException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage());
        }
        dispose();
    }

    /**
     * "LZ"{^̏B
     */
    void onButtonCancelClicked() {
        dispose();
    }

    /**
     * (O)bZ[W̎擾B
     * @param key L[
     * @return bZ[W
     */
    private static String getMessage(String key) {
        return Messages.getString("dialog.ConnectorMapEditDialog." + key);
    }

}