/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.text;

public final class Trimmer {
    public static final Trimmer LEFT = new Trimmer(1);
    public static final Trimmer RIGHT = new Trimmer(2);
    private static final String EMPTY = "";
    private static final char SPACE = ' ';
    private final int code;

    private Trimmer(int n) {
        this.code = n;
    }

    public static String trim(String string, int n) {
        return Trimmer.trim(string, n, LEFT);
    }

    public static String trim(String string, int n, Trimmer trimmer) {
        int n2 = string.getBytes().length;
        if (n2 < n) {
            return Trimmer.pad(string, n, ' ', trimmer);
        }
        if (n2 > n) {
            return Trimmer.cut(string, n, trimmer);
        }
        return string;
    }

    public static String pad(String string, int n) {
        return Trimmer.pad(string, n, ' ');
    }

    public static String pad(String string, int n, char c) {
        return Trimmer.pad(string, n, c, LEFT);
    }

    public static String pad(String string, int n, char c, Trimmer trimmer) {
        StringBuffer stringBuffer;
        block4: {
            block3: {
                if (n <= string.getBytes().length) {
                    return string;
                }
                stringBuffer = new StringBuffer(string);
                if (trimmer != LEFT) break block3;
                while (stringBuffer.toString().getBytes().length < n) {
                    stringBuffer.append(c);
                }
                break block4;
            }
            if (trimmer != RIGHT) break block4;
            while (stringBuffer.toString().getBytes().length < n) {
                stringBuffer.insert(0, c);
            }
        }
        return stringBuffer.toString();
    }

    public static String cut(String string, int n) {
        return Trimmer.cut(string, n, LEFT);
    }

    public static String cut(String string, int n, Trimmer trimmer) {
        if (n <= 0) {
            return EMPTY;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        while (n < stringBuffer.toString().getBytes().length) {
            if (trimmer == LEFT) {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                continue;
            }
            if (trimmer != RIGHT) continue;
            stringBuffer.deleteCharAt(0);
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.code;
        return n;
    }
}

