/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.io;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.ColumnOrder;
import net.argius.stew.OutputProcessor;
import net.argius.stew.ResultSetReference;
import net.argius.stew.io.Exporter;

public final class ExporterOutputProcessor
implements OutputProcessor {
    private static final Logger log = LoggerFactory.getLogger(ExporterOutputProcessor.class);
    private final Exporter exporter;
    private final OutputProcessor output;
    private final boolean withHeader;

    public ExporterOutputProcessor(Exporter exporter, OutputProcessor outputProcessor, boolean bl) {
        this.exporter = exporter;
        this.output = outputProcessor;
        this.withHeader = bl;
    }

    public void output(Object object) {
        try {
            if (object instanceof ResultSetReference) {
                ResultSetReference resultSetReference = (ResultSetReference)object;
                ColumnOrder columnOrder = resultSetReference.getOrder();
                int n = this.outputResultSet(resultSetReference.getResultSet(), columnOrder);
                resultSetReference.setRecordCount(n);
            } else {
                this.output.output(object);
            }
        }
        catch (IOException iOException) {
            log.error("", iOException);
            this.output.output(iOException.getMessage());
        }
        catch (SQLException sQLException) {
            log.error("", sQLException);
            this.output.output(sQLException.getMessage());
        }
    }

    private int outputResultSet(ResultSet resultSet, ColumnOrder columnOrder) throws IOException, SQLException {
        int n;
        int n2;
        int n3 = 0;
        boolean bl = columnOrder.size() > 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            n2 = columnOrder.size();
            for (int i = 0; i < n2; ++i) {
                arrayList.add(columnOrder.getName(i));
            }
        } else {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            n2 = resultSetMetaData.getColumnCount();
            for (n = 0; n < n2; ++n) {
                arrayList.add(resultSetMetaData.getColumnName(n + 1));
            }
        }
        if (this.withHeader) {
            this.exporter.addHeader(arrayList.toArray());
        }
        while (resultSet.next()) {
            ++n3;
            Object[] objectArray = new Object[n2];
            for (n = 0; n < n2; ++n) {
                int n4 = bl ? columnOrder.getOrder(n) : n + 1;
                objectArray[n] = resultSet.getObject(n4);
            }
            this.exporter.addRow(objectArray);
        }
        return n3;
    }

    public void close() {
    }
}

