/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.gui;

import java.awt.Font;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import net.argius.stew.gui.FormedFont;
import net.argius.stew.gui.Window;
import net.argius.stew.io.Path;

public final class WindowConfiguration
implements Serializable {
    private static final long serialVersionUID = -2434363413626808526L;
    private static final String CLASS_NAME = WindowConfiguration.class.getName();
    private static final String FILE_NAME = CLASS_NAME + ".xml";
    private int width = 640;
    private int height = 400;
    private int x = 10;
    private int y = 10;
    private int separatorX = 256;
    private Font font = FormedFont.Regular;
    private boolean statusBarVisibility = false;

    public void apply(Window window) {
        window.setSize(this.width, this.height);
        window.setLocation(this.x, this.y);
        window.setDividerLocation(this.separatorX);
        window.setFont(this.font);
        window.setStatusBarVisibility(this.statusBarVisibility);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(Window window, File file) throws IOException {
        WindowConfiguration windowConfiguration;
        File file2 = new File(file, FILE_NAME);
        try {
            FileInputStream fileInputStream = new FileInputStream(file2);
            XMLDecoder xMLDecoder = new XMLDecoder(fileInputStream);
            try {
                windowConfiguration = (WindowConfiguration)xMLDecoder.readObject();
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            windowConfiguration = new WindowConfiguration();
        }
        windowConfiguration.apply(window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(Window window, File file) throws IOException {
        Path.makeDirectory(file);
        WindowConfiguration windowConfiguration = new WindowConfiguration();
        windowConfiguration.width = window.getWidth();
        windowConfiguration.height = window.getHeight();
        windowConfiguration.x = window.getX();
        windowConfiguration.y = window.getY();
        windowConfiguration.separatorX = window.getDividerLocation();
        windowConfiguration.font = window.getFont();
        windowConfiguration.statusBarVisibility = window.getStatusBarVisibility();
        File file2 = new File(file, FILE_NAME);
        XMLEncoder xMLEncoder = new XMLEncoder(new FileOutputStream(file2));
        try {
            xMLEncoder.writeObject(windowConfiguration);
        }
        finally {
            xMLEncoder.close();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int n) {
        this.x = n;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int n) {
        this.y = n;
    }

    public int getSeparatorX() {
        return this.separatorX;
    }

    public void setSeparatorX(int n) {
        this.separatorX = n;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public boolean isStatusBarVisibility() {
        return this.statusBarVisibility;
    }

    public void setStatusBarVisibility(boolean bl) {
        this.statusBarVisibility = bl;
    }
}

