/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.argius.stew.Launcher;
import net.argius.stew.gui.MainIcon;
import net.argius.version.Version;

public final class VersionInfoAction
extends AbstractAction {
    private static final String FONT_FAMILY = "Arial";
    private static final Font FONT_L = new Font("Arial", 1, 14);
    private static final Font FONT_M = new Font("Arial", 0, 12);
    private static final Font FONT_S = new Font("Arial", 0, 10);
    private final Component parent;

    public VersionInfoAction(Component component) {
        this.parent = component;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Version version = Version.getInstance(Launcher.class);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(version.getBuildTime());
        String string = "Stew - SQL client tool with JDBC";
        String string2 = "version " + version.getRegularString();
        String string3 = "build #" + version.getBuildNumber() + " : " + calendar.getTime();
        String string4 = "Copyright : argius 2005-2009".replaceFirst("[0-9]{4}$", "") + calendar.get(1);
        JPanel jPanel = new JPanel(new GridLayout(5, 1));
        jPanel.setOpaque(false);
        JLabel jLabel = VersionInfoAction.createJLabel(string, FONT_L);
        jLabel.setForeground(new Color(64, 64, 192));
        jPanel.add(jLabel);
        jPanel.add(VersionInfoAction.createJLabel(string2, FONT_M));
        jPanel.add(VersionInfoAction.createJLabel(string3, FONT_S));
        jPanel.add(new JLabel());
        jPanel.add(VersionInfoAction.createJLabel(string4, FONT_M));
        JOptionPane jOptionPane = new JOptionPane(jPanel, 1, -1);
        jOptionPane.setIcon(new MainIcon());
        JDialog jDialog = jOptionPane.createDialog(this.parent, null);
        VersionInfoAction.setupComponents(jDialog);
        jDialog.setVisible(true);
    }

    private static void setupComponents(Container container) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (component instanceof Container) {
                Container container2 = (Container)component;
                VersionInfoAction.setupComponents(container2);
            }
            component.setBackground(Color.WHITE);
        }
    }

    private static JLabel createJLabel(String string, Font font) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(font);
        return jLabel;
    }
}

