/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.gui;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableColumnModel;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.gui.ContextMenu;
import net.argius.stew.gui.DialogMessage;
import net.argius.stew.gui.ResultSetTable;
import net.argius.stew.gui.ResultSetTableModel;
import net.argius.stew.gui.TabSeparatedTextImporter;
import net.argius.stew.io.Exporter;
import net.argius.stew.io.Importer;
import net.argius.stew.io.SimpleExporter;

final class ResultSetTableAction {
    static final String ADJUST_COLUMN_SIZE = "adjust-column-size";
    static final String COPY_CELL_WITH_ESCAPE = "copy-cell-with-escape";
    static final String COPY_COLUMN_NAMES = "copy-column-names";
    static final String PASTE_TO_SELECTED_CELLS = "paste-to-selectedCells";
    static final String SET_NULL_TO_SELECTED_CELLS = "set-null-to-selectedCells";
    static final String ADD_NEW_ROW = "add-new-row";
    static final String ADD_DUPLICATE_ROW = "add-duplicate-row";
    static final String INSERT_FROM_CLIPBOARD = "insert-from-clipboard";
    static final String INSERT_ADDED_ROWS = "insert-added-rows";
    static final String DELETE_SELECTED_ROWS = "delete-selected-rows";
    private static final Logger log = LoggerFactory.getLogger(ResultSetTableAction.class);
    final ResultSetTable table;
    final ContextMenu contextMenu;
    private final InputMap imap;
    private final ActionMap amap;

    private ResultSetTableAction(ResultSetTable resultSetTable) {
        this.table = resultSetTable;
        this.contextMenu = new ContextMenu(resultSetTable);
        this.imap = resultSetTable.getInputMap();
        this.amap = resultSetTable.getActionMap();
    }

    static void bindAction(ResultSetTable resultSetTable) {
        ResultSetTableAction resultSetTableAction = new ResultSetTableAction(resultSetTable);
        resultSetTableAction.bindAdjustColumnSize();
        resultSetTableAction.bindCopyCellWithEscape();
        resultSetTableAction.bindCopyColumnNames();
        resultSetTableAction.bindPasteToSelectedCells();
        resultSetTableAction.bindSetNullToSelectedCells();
        resultSetTableAction.bindAddNewRow();
        resultSetTableAction.bindAddDuplicateRow();
        resultSetTableAction.bindInsertFromClipboard();
        resultSetTableAction.bindInsertAddedRows();
        resultSetTableAction.bindDeleteSelectedRows();
    }

    private void bindAdjustColumnSize() {
        String string = ADJUST_COLUMN_SIZE;
        this.amap.put(string, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultSetTableAction.this.table.adjustColumnWidth();
            }
        });
        this.imap.put(ResultSetTableAction.getKeyStroke(47, true), string);
    }

    private void bindCopyCellWithEscape() {
        String string = COPY_CELL_WITH_ESCAPE;
        this.amap.put(string, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultSetTableAction.this.copyValueAtSelectedCells();
            }
        });
        int n = 640;
        this.imap.put(KeyStroke.getKeyStroke(67, n), string);
    }

    private void bindCopyColumnNames() {
        String string = COPY_COLUMN_NAMES;
        this.amap.put(string, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultSetTableAction.this.copyColumnNames();
            }
        });
    }

    private void bindPasteToSelectedCells() {
        String string = PASTE_TO_SELECTED_CELLS;
        this.amap.put(string, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultSetTableAction.this.pasteValueToSelectedCells();
            }
        });
        this.imap.put(ResultSetTableAction.getKeyStroke(86, true), string);
    }

    private void bindSetNullToSelectedCells() {
        String string = SET_NULL_TO_SELECTED_CELLS;
        this.amap.put(string, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultSetTableAction.this.resetValueAtSelectedCells();
            }
        });
        this.imap.put(ResultSetTableAction.getKeyStroke(127, false), string);
        this.imap.put(ResultSetTableAction.getKeyStroke(82, true), string);
    }

    private void bindAddNewRow() {
        String string = ADD_NEW_ROW;
        this.amap.put(string, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultSetTableAction.this.addNewRow();
            }
        });
        int n = 192;
        this.imap.put(KeyStroke.getKeyStroke(59, n), string);
    }

    private void bindAddDuplicateRow() {
        String string = ADD_DUPLICATE_ROW;
        this.amap.put(string, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultSetTableAction.this.addDuplicateRows();
            }
        });
    }

    private void bindInsertFromClipboard() {
        String string = INSERT_FROM_CLIPBOARD;
        this.amap.put(string, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultSetTableAction.this.insertFromClipboard();
            }
        });
    }

    private void bindInsertAddedRows() {
        String string = INSERT_ADDED_ROWS;
        this.amap.put(string, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultSetTableAction.this.insertAddedRows();
            }
        });
    }

    private void bindDeleteSelectedRows() {
        String string = DELETE_SELECTED_ROWS;
        this.amap.put(string, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultSetTableAction.this.deleteSelectedRows();
            }
        });
        int n = 192;
        this.imap.put(KeyStroke.getKeyStroke(45, n), string);
    }

    private static KeyStroke getKeyStroke(int n, boolean bl) {
        return KeyStroke.getKeyStroke(n, bl ? 128 : 0);
    }

    void onError(Throwable throwable) {
        log.error("", throwable);
        DialogMessage.alert(this.table, throwable.getMessage());
    }

    void copyValueAtSelectedCells() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        SimpleExporter simpleExporter = new SimpleExporter(byteArrayOutputStream, "\t");
        int[] nArray = this.table.getSelectedColumns();
        int[] nArray2 = this.table.getSelectedRows();
        int n = nArray.length;
        try {
            Object object;
            for (int i = 0; i < nArray2.length; ++i) {
                int n2 = nArray2[i];
                object = new Object[n];
                for (int j = 0; j < n; ++j) {
                    int n3 = nArray[j];
                    Object object2 = this.table.getValueAt(n2, n3);
                    if (object2 == null) {
                        object2 = "";
                    }
                    object[j] = object2;
                }
                ((Exporter)simpleExporter).addRow((Object[])object);
            }
            String string = byteArrayOutputStream.toString().replaceAll("\\r", "");
            if (log.isTraceEnabled()) {
                StringWriter stringWriter = new StringWriter();
                object = new PrintWriter(stringWriter);
                ((PrintWriter)object).println("to clipboard:");
                ((PrintWriter)object).print(string);
                log.trace(stringWriter);
            }
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            object = new StringSelection(string);
            clipboard.setContents((Transferable)object, (ClipboardOwner)object);
        }
        catch (IOException iOException) {
            this.onError(iOException);
        }
    }

    void copyColumnNames() {
        TableColumnModel tableColumnModel = this.table.getTableHeader().getColumnModel();
        int n = tableColumnModel.getColumnCount();
        if (n < 1) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuffer.append('\t');
            }
            stringBuffer.append(tableColumnModel.getColumn(i).getHeaderValue());
        }
        if (log.isTraceEnabled()) {
            log.trace("to clipboard:" + stringBuffer);
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        clipboard.setContents(stringSelection, stringSelection);
    }

    void pasteValueToSelectedCells() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        try {
            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            ResultSetTableAction.paste(this.table, string);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            this.onError(unsupportedFlavorException);
        }
        catch (IOException iOException) {
            this.onError(iOException);
        }
        catch (SQLException sQLException) {
            this.onError(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void paste(JTable jTable, String string) throws IOException, SQLException {
        ResultSetTableModel resultSetTableModel = (ResultSetTableModel)jTable.getModel();
        TabSeparatedTextImporter tabSeparatedTextImporter = new TabSeparatedTextImporter(string);
        try {
            int[] nArray = jTable.getSelectedColumns();
            int[] nArray2 = jTable.getSelectedRows();
            int n = nArray.length;
            for (int i = 0; i < nArray2.length; ++i) {
                int n2 = nArray2[i];
                boolean bl = resultSetTableModel.isInsertRow(n2);
                Object[] objectArray = ((Importer)tabSeparatedTextImporter).nextRow();
                int n3 = Math.min(n, objectArray.length);
                for (int j = 0; j < n3; ++j) {
                    int n4 = nArray[j];
                    Object object = jTable.getValueAt(n2, n4);
                    Object object2 = objectArray[j];
                    if (!bl) {
                        resultSetTableModel.updateValueChanged(jTable, n2, n4, object, object2);
                    }
                    jTable.setValueAt(object2, n2, n4);
                }
            }
        }
        finally {
            ((Importer)tabSeparatedTextImporter).close();
        }
    }

    void resetValueAtSelectedCells() {
        try {
            ResultSetTableModel resultSetTableModel = (ResultSetTableModel)this.table.getModel();
            int[] nArray = this.table.getSelectedColumns();
            int[] nArray2 = this.table.getSelectedRows();
            int n = nArray.length;
            for (int i = 0; i < nArray2.length; ++i) {
                int n2 = nArray2[i];
                for (int j = 0; j < n; ++j) {
                    int n3 = nArray[j];
                    Object object = this.table.getValueAt(n2, n3);
                    resultSetTableModel.updateValueChanged(this.table, n2, n3, object, null);
                    this.table.setValueAt(null, n2, n3);
                }
            }
        }
        catch (SQLException sQLException) {
            this.onError(sQLException);
        }
    }

    void addNewRow() {
        ResultSetTableModel resultSetTableModel = (ResultSetTableModel)this.table.getModel();
        int n = resultSetTableModel.getRowCount();
        resultSetTableModel.addRowAsInsert(new Object[resultSetTableModel.getColumnCount()]);
        this.table.changeSelection(n, 1, false, false);
    }

    void addDuplicateRows() {
        ResultSetTableModel resultSetTableModel = (ResultSetTableModel)this.table.getModel();
        int[] nArray = this.table.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            List list = resultSetTableModel.getDataVector().get(nArray[i]);
            resultSetTableModel.addRowAsInsert(list.toArray());
            this.table.changeSelection(resultSetTableModel.getRowCount(), 1, false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertFromClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            Transferable transferable = clipboard.getContents(null);
            Object object = transferable.getTransferData(DataFlavor.stringFlavor);
            ResultSetTableModel resultSetTableModel = (ResultSetTableModel)this.table.getModel();
            TabSeparatedTextImporter tabSeparatedTextImporter = new TabSeparatedTextImporter(String.valueOf(object));
            try {
                Object[] objectArray;
                ArrayList<SQLException> arrayList = new ArrayList<SQLException>();
                int n = this.table.getRowCount();
                while ((objectArray = ((Importer)tabSeparatedTextImporter).nextRow()).length != 0) {
                    resultSetTableModel.addRowAsInsert(objectArray);
                    try {
                        resultSetTableModel.updateRowInserted(this.table, n);
                    }
                    catch (SQLException sQLException) {
                        log.warn("", sQLException);
                        arrayList.add(sQLException);
                    }
                    ++n;
                }
                if (!arrayList.isEmpty()) {
                    String string = arrayList.size() + " error(s) occurred";
                    DialogMessage.alert(this.table, string);
                }
            }
            finally {
                ((Importer)tabSeparatedTextImporter).close();
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            this.onError(unsupportedFlavorException);
        }
        catch (IOException iOException) {
            this.onError(iOException);
        }
        catch (RuntimeException runtimeException) {
            this.onError(runtimeException);
        }
    }

    void insertAddedRows() {
        try {
            ResultSetTableModel resultSetTableModel = (ResultSetTableModel)this.table.getModel();
            int[] nArray = this.table.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                resultSetTableModel.updateRowInserted(this.table, nArray[i]);
            }
        }
        catch (SQLException sQLException) {
            this.onError(sQLException);
        }
        catch (RuntimeException runtimeException) {
            this.onError(runtimeException);
        }
    }

    void deleteSelectedRows() {
        ResultSetTableModel resultSetTableModel = (ResultSetTableModel)this.table.getModel();
        int[] nArray = this.table.getSelectedRows();
        int n = nArray.length;
        if (n < 1) {
            return;
        }
        int n2 = nArray[0];
        for (int i = 0; i < n; ++i) {
            boolean bl = resultSetTableModel.isInsertRow(n2);
            if (!bl) {
                try {
                    resultSetTableModel.updateRowDeleted(this.table, new int[]{n2});
                }
                catch (SQLException sQLException) {
                    this.onError(sQLException);
                }
            }
            resultSetTableModel.removeRow(n2);
        }
    }
}

