/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.command;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.ColumnOrder;
import net.argius.stew.Command;
import net.argius.stew.CommandException;
import net.argius.stew.Messages;
import net.argius.stew.Parameter;
import net.argius.stew.ResultSetReference;
import net.argius.stew.UsageException;

public final class Report
extends Command {
    private static final Logger log = LoggerFactory.getLogger(Report.class);
    private static final String USAGE = Report.getUsage("report");

    public void execute(Connection connection, Parameter parameter) throws CommandException {
        if (parameter.isEmpty(2)) {
            throw new UsageException(USAGE);
        }
        try {
            String string = parameter.get(2);
            if (string.equals("-")) {
                this.reportDBInfo(connection);
            } else {
                String string2 = string;
                String string3 = parameter.get(3);
                if (string3.equalsIgnoreCase("PK")) {
                    this.reportPrimaryKeyInfo(connection, string2);
                } else if (string3.equalsIgnoreCase("INDEX")) {
                    this.reportIndexInfo(connection, string2);
                } else {
                    this.reportTableDescription(connection, string2);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new CommandException(sQLException);
        }
    }

    public boolean isReadOnly() {
        return true;
    }

    private String getColumnName(String string) {
        return Messages.getString("command.report.label." + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportTableDescription(Connection connection, String string) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("report table-description of : " + string);
        }
        String string2 = this.convertPattern(string);
        ResultSet resultSet = connection.getMetaData().getColumns(null, null, string2, null);
        try {
            ResultSetReference resultSetReference = new ResultSetReference(resultSet);
            ColumnOrder columnOrder = resultSetReference.getOrder();
            columnOrder.addOrder(17, this.getColumnName("sequence"));
            columnOrder.addOrder(4, this.getColumnName("columnname"));
            columnOrder.addOrder(18, this.getColumnName("nullable"));
            columnOrder.addOrder(6, this.getColumnName("type"));
            columnOrder.addOrder(7, this.getColumnName("size"));
            columnOrder.addOrder(2, this.getColumnName("schema"));
            this.output(resultSetReference);
            Object[] objectArray = new Object[]{new Integer(resultSetReference.getRecordCount())};
            this.outputMessage(".selected", objectArray);
        }
        finally {
            resultSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportPrimaryKeyInfo(Connection connection, String string) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("report primary-key of : " + string);
        }
        String string2 = this.convertPattern(string);
        ResultSet resultSet = connection.getMetaData().getPrimaryKeys(null, null, string2);
        try {
            ResultSetReference resultSetReference = new ResultSetReference(resultSet);
            ColumnOrder columnOrder = resultSetReference.getOrder();
            columnOrder.addOrder(1, this.getColumnName("catalog"));
            columnOrder.addOrder(2, this.getColumnName("schema"));
            columnOrder.addOrder(3, this.getColumnName("tablename"));
            columnOrder.addOrder(5, this.getColumnName("sequence"));
            columnOrder.addOrder(4, this.getColumnName("columnname"));
            columnOrder.addOrder(6, this.getColumnName("keyname"));
            this.output(resultSetReference);
            Object[] objectArray = new Object[]{new Integer(resultSetReference.getRecordCount())};
            this.outputMessage(".selected", objectArray);
        }
        finally {
            resultSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportIndexInfo(Connection connection, String string) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("report index of : " + string);
        }
        String string2 = this.convertPattern(string);
        ResultSet resultSet = connection.getMetaData().getIndexInfo(null, null, string2, false, false);
        try {
            ResultSetReference resultSetReference = new ResultSetReference(resultSet);
            ColumnOrder columnOrder = resultSetReference.getOrder();
            columnOrder.addOrder(1, this.getColumnName("catalog"));
            columnOrder.addOrder(2, this.getColumnName("schema"));
            columnOrder.addOrder(3, this.getColumnName("tablename"));
            columnOrder.addOrder(8, this.getColumnName("sequence"));
            columnOrder.addOrder(9, this.getColumnName("columnname"));
            columnOrder.addOrder(6, this.getColumnName("keyname"));
            this.output(resultSetReference);
            Object[] objectArray = new Object[]{new Integer(resultSetReference.getRecordCount())};
            this.outputMessage(".selected", objectArray);
        }
        finally {
            resultSet.close();
        }
    }

    private void reportDBInfo(Connection connection) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("report dbinfo");
        }
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        Object[] objectArray = new Object[]{databaseMetaData.getDatabaseProductName()};
        this.outputMessage("command.report.product.name", objectArray);
        Object[] objectArray2 = new Object[]{databaseMetaData.getDatabaseProductVersion()};
        this.outputMessage("command.report.product.version", objectArray2);
        Object[] objectArray3 = new Object[]{databaseMetaData.getDriverName()};
        this.outputMessage("command.report.driver.name", objectArray3);
        Object[] objectArray4 = new Object[]{databaseMetaData.getDriverVersion()};
        this.outputMessage("command.report.driver.version", objectArray4);
        Object[] objectArray5 = new Object[]{databaseMetaData.getURL()};
        this.outputMessage("command.report.url", objectArray5);
    }
}

