/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.command;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.CommandException;
import net.argius.stew.Parameter;
import net.argius.stew.UsageException;
import net.argius.stew.command.Load;
import net.argius.stew.io.Importer;

public final class Import
extends Load {
    private static final Logger log = LoggerFactory.getLogger(Import.class);
    private static final String USAGE = Import.getUsage("import");
    private static final int DEFAULT_BATCH_LIMIT = 10000;

    public void execute(Connection connection, Parameter parameter) throws CommandException {
        if (parameter.isEmpty(3)) {
            throw new UsageException(USAGE);
        }
        int n = 2;
        String string = parameter.get(n++);
        String string2 = parameter.get(n++);
        String string3 = parameter.get(n++);
        boolean bl = string3.equalsIgnoreCase("header");
        if (log.isDebugEnabled()) {
            log.debug("file : " + string);
            log.debug("table : " + string2);
            log.debug("hasHeader : " + bl);
        }
        try {
            this.loadRecord(connection, new File(string), string2, bl);
        }
        catch (IOException iOException) {
            throw new CommandException(iOException);
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException.getNextException();
            if (sQLException2 != null && sQLException2 != sQLException) {
                log.error("next exception: ", sQLException2);
            }
            throw new CommandException(sQLException);
        }
    }

    protected void insertRecords(PreparedStatement preparedStatement, Importer importer) throws IOException, SQLException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            int n4;
            Object[] objectArray;
            boolean bl;
            boolean bl2 = bl = (objectArray = importer.nextRow()).length == 0;
            if (!bl) {
                ++n;
                try {
                    for (n4 = 0; n4 < objectArray.length; ++n4) {
                        preparedStatement.setObject(n4 + 1, objectArray[n4]);
                    }
                    preparedStatement.addBatch();
                }
                catch (SQLException sQLException) {
                    String string = "error occurred at " + n;
                    if (log.isTraceEnabled()) {
                        log.trace(string, sQLException);
                    } else if (log.isDebugEnabled()) {
                        log.debug(string + " : " + sQLException);
                    }
                    ++n3;
                }
            }
            if (n % 10000 != 0 && !bl) continue;
            n4 = Import.executeBatch(preparedStatement);
            n2 += n4;
            if (log.isDebugEnabled()) {
                log.debug("record/inserted = " + n + "/" + n2);
            }
            if (bl) break;
        }
        if (n3 > 0) {
            log.warn("error count = " + n3);
        }
        this.outputMessage(".loaded", new Object[]{new Integer(n2), new Integer(n)});
    }

    private static int executeBatch(PreparedStatement preparedStatement) throws SQLException {
        int[] nArray = preparedStatement.executeBatch();
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i];
        }
        if (n != nArray.length) {
            log.warn("array size = " + nArray.length + ", but result count = " + n);
        }
        preparedStatement.clearBatch();
        return n;
    }
}

