/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.Command;
import net.argius.stew.Environment;
import net.argius.stew.Launcher;
import net.argius.stew.OutputProcessor;
import net.argius.stew.Prompt;
import net.argius.version.Version;

public final class StandardInputLauncher
implements Launcher {
    private static final Logger log = LoggerFactory.getLogger(StandardInputLauncher.class);

    public void launch(Environment environment) {
        if (log.isInfoEnabled()) {
            log.info("start");
        }
        OutputProcessor outputProcessor = environment.getOutputProcessor();
        outputProcessor.output("Stew - SQL client tool with JDBC");
        outputProcessor.output("version " + Version.getInstance(Launcher.class));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        try {
            boolean bl;
            String string;
            Prompt prompt = new Prompt(environment);
            do {
                outputProcessor.output(prompt);
                string = bufferedReader.readLine();
                if (!log.isDebugEnabled()) continue;
                log.debug("input : " + string);
            } while (string != null && (bl = Command.invoke(environment, string)));
        }
        catch (IOException iOException) {
            log.error("", iOException);
            outputProcessor.output(iOException);
        }
        if (log.isInfoEnabled()) {
            log.info("end");
        }
    }
}

