package net.argius.stew.io;

import java.io.*;

import net.argius.stew.*;
import net.argius.stew.io.StringBasedSerializer.*;

/**
 * XML`̃GNX|[gB
 */
public final class XmlExporter extends Exporter {

    private static final String ENCODING = "utf-8";
    private static final String TAG_TABLE = "table";
    private static final String TAG_TABLE_START = "<"
                                                  + TAG_TABLE
                                                  + " writer=\""
                                                  + XmlExporter.class.getName()
                                                  + "\">";
    private static final String TAG_TABLE_END = "</" + TAG_TABLE + ">";
    private static final String TAG_HEADERROW = "headerrow";
    private static final String TAG_HEADERROW_END = "</" + TAG_HEADERROW + ">";
    private static final String TAG_HEADERROW_START = "<" + TAG_HEADERROW + ">";
    private static final String TAG_HEADER = "header";
    private static final String TAG_HEADER_START = "<" + TAG_HEADER;
    private static final String TAG_HEADER_END = "</" + TAG_HEADER + ">";
    private static final String TAG_ROW = "row";
    private static final String TAG_ROW_START = "<" + TAG_ROW + ">";
    private static final String TAG_ROW_END = "</" + TAG_ROW + ">";

    private PrintWriter out;

    /**
     * XmlExporter̐B
     * @param outputStream o̓Xg[ 
     */
    public XmlExporter(OutputStream outputStream) {
        super(outputStream);
        try {
            this.out = new PrintWriter(new OutputStreamWriter(outputStream,
                                                              ENCODING));
            out.println("<?xml version=\"1.0\" encoding=\"" + ENCODING + "\"?>");
            out.println("<!DOCTYPE "
                        + TAG_TABLE
                        + " SYSTEM \"stew-table.dtd\">");
            out.println(TAG_TABLE_START);
        } catch (UnsupportedEncodingException ex) {
            UnexpectedError error = new UnexpectedError();
            error.initCause(ex);
            throw error;
        }
    }

    /**
     * KvȏꍇCDATAZNVɕϊB
     * @param string (Null)
     * @return KvȂCDATAZNV
     */
    private static String convertCData(String string) {
        String s = string;
        if (s.indexOf('<') >= 0 || s.indexOf('>') >= 0) {
            if (s.indexOf("]]>") >= 0) {
                s = s.replaceAll("\\]\\]>", "]]&gt;");
            }
            return "<![CDATA[" + s + "]]>";
        } else {
            return s;
        }
    }

    /* (overridden)
     * @see net.argius.stew.io.Exporter#writeHeader(java.lang.Object[])
     */
    protected void writeHeader(Object[] header) throws IOException {
        out.println(TAG_HEADERROW_START);
        for (int i = 0; i < header.length; i++) {
            Object o = header[i];
            out.print(TAG_HEADER_START);
            out.print(" index=\"" + i + "\">");
            out.print(convertCData(String.valueOf(o)));
            out.println(TAG_HEADER_END);
        }
        out.println(TAG_HEADERROW_END);
        out.flush();
    }

    /*
     * (overridden)
     * @see net.argius.stew.io.Exporter#close()
     */
    public void close() throws IOException {
        try {
            if (out != null) {
                out.print(TAG_TABLE_END);
                out.close();
            }
        } finally {
            out = null;
            super.close();
        }
    }

    /*
     * (overridden)
     * @see net.argius.stew.io.Exporter#addRow(java.lang.Object[])
     */
    public void addRow(Object[] row) throws IOException {
        out.print(TAG_ROW_START);
        for (int i = 0; i < row.length; i++) {
            Object o = row[i];
            Element element = StringBasedSerializer.serialize(o);
            String type = element.getType();
            if (element.isNull()) {
                out.print("<" + type + "/>");
            } else {
                out.print("<" + type);
                if (type.equals(Element.OBJECT)) {
                    out.print(" class=\"");
                    out.print(o.getClass().getName());
                    out.print("\"");
                } else if (type.equals(Element.TIME)) {
                    out.print(" display=\"");
                    out.print(o);
                    out.print("\"");
                }
                out.print(">");
                out.print(convertCData(element.getValue()));
                out.print("</" + type + ">");
            }
        }
        out.println(TAG_ROW_END);
        out.flush();
    }

}