package net.argius.stew.io;

import java.io.*;

/**
 * Exporter̃t@NgB
 */
final class ExporterFactory {

    /**
     * ExporterFactory̐B
     */
    private ExporterFactory() {
        // empty
    }

    /**
     * Exporter̐B
     * @param path pX
     * @return Exporter
     * @throws IOException o̓G[ꍇ
     */
    static Exporter createExporter(Path path) throws IOException {
        String suffix = path.getSuffix();
        if (suffix.equalsIgnoreCase("xml")) {
            return new XmlExporter(openFile(path));
        } else if (suffix.equalsIgnoreCase("htm")
                   || suffix.equalsIgnoreCase("html")) {
            return new HtmlExporter(openFile(path), "");
        } else if (suffix.equalsIgnoreCase("csv")) {
            return new SimpleExporter(openFile(path), ",");
        } else {
            return new SimpleExporter(openFile(path), "\t");
        }
    }

    /**
     * t@CJB
     * @param file t@C
     * @return o̓Xg[
     * @throws IOException o̓G[ꍇ
     */
    private static OutputStream openFile(File file) throws IOException {
        return new FileOutputStream(file);
    }

}
