package net.argius.logging;

/**
 * Logger̊B
 */
public abstract class BasicLogger implements Logger {

    private boolean isInfoEnabled;
    private boolean isDebugEnabled;
    private boolean isTraceEnabled;

    /**
     * StandardErrorOutputLogger̐B
     */
    protected BasicLogger() {
        // empty
    }

    /**
     * bZ[W̏óB
     * @param levelString x
     * @param object o͓e
     */
    protected abstract void printMessage(String levelString, Object object);

    /**
     * ȌóB
     * @param th O
     */
    protected abstract void printStackTrace(Throwable th);

    /**
     * LoggerĂяoꂽΏۃNX̍sԍ𓾂B
     * @param targetClassName ΏۃNX
     * @return sԍ s̏ꍇ<code>-1</code>
     */
    protected static int getLineNumber(String targetClassName) {
        try {
            throw new Exception();
        } catch (Exception ex) {
            StackTraceElement[] elements = ex.getStackTrace();
            for (int i = 0; i < elements.length; i++) {
                StackTraceElement element = elements[i];
                if (element != null
                    && targetClassName.equals(element.getClassName())) {
                    return element.getLineNumber();
                }
            }
        }
        return -1;
    }

    /* (overridden)
     * @see net.argius.logging.Logger#setLevel(java.lang.String)
     */
    public void setLevel(String level) {
        if (level == null) {
            return;
        }
        if (level.equalsIgnoreCase("INFO")) {
            isInfoEnabled = true;
            isDebugEnabled = false;
            isTraceEnabled = false;
        } else if (level.equalsIgnoreCase("DEBUG")) {
            isInfoEnabled = true;
            isDebugEnabled = true;
            isTraceEnabled = false;
        } else if (level.equalsIgnoreCase("TRACE")) {
            isInfoEnabled = true;
            isDebugEnabled = true;
            isTraceEnabled = true;
        }
    }

    /* (overridden)
     * @see net.argius.logging.Logger#isInfoEnabled()
     */
    public boolean isInfoEnabled() {
        return isInfoEnabled;
    }

    /* (overridden)
     * @see net.argius.logging.Logger#isDebugEnabled()
     */
    public boolean isDebugEnabled() {
        return isDebugEnabled;
    }

    /* (overridden)
     * @see net.argius.logging.Logger#isTraceEnabled()
     */
    public boolean isTraceEnabled() {
        return isTraceEnabled;
    }

    /* (overridden)
     * @see net.argius.logging.Logger#fatal(java.lang.Object, java.lang.Throwable)
     */
    public void fatal(Object object, Throwable th) {
        fatal(object);
        printStackTrace(th);
    }

    /* (overridden)
     * @see net.argius.logging.Logger#fatal(java.lang.Object)
     */
    public void fatal(Object object) {
        printMessage("FATAL", object);
    }

    /* (overridden)
     * @see net.argius.logging.Logger#error(java.lang.Object, java.lang.Throwable)
     */
    public void error(Object object, Throwable th) {
        error(object);
        printStackTrace(th);
    }

    /* (overridden)
     * @see net.argius.logging.Logger#error(java.lang.Object)
     */
    public void error(Object object) {
        printMessage("ERROR", object);
    }

    /* (overridden)
     * @see net.argius.logging.Logger#warn(java.lang.Object, java.lang.Throwable)
     */
    public void warn(Object object, Throwable th) {
        warn(object);
        printStackTrace(th);
    }

    /* (overridden)
     * @see net.argius.logging.Logger#warn(java.lang.Object)
     */
    public void warn(Object object) {
        printMessage("WARN", object);
    }

    /* (overridden)
     * @see net.argius.logging.Logger#info(java.lang.Object, java.lang.Throwable)
     */
    public void info(Object object, Throwable th) {
        if (isInfoEnabled()) {
            info(object);
            printStackTrace(th);
        }
    }

    /* (overridden)
     * @see net.argius.logging.Logger#info(java.lang.Object)
     */
    public void info(Object object) {
        if (isInfoEnabled()) {
            printMessage("INFO ", object);
        }
    }

    /* (overridden)
     * @see net.argius.logging.Logger#debug(java.lang.Object, java.lang.Throwable)
     */
    public void debug(Object object, Throwable th) {
        if (isDebugEnabled()) {
            debug(object);
            printStackTrace(th);
        }
    }

    /* (overridden)
     * @see net.argius.logging.Logger#debug(java.lang.Object)
     */
    public void debug(Object object) {
        if (isDebugEnabled()) {
            printMessage("DEBUG", object);
        }
    }

    /* (overridden)
     * @see net.argius.logging.Logger#trace(java.lang.Object, java.lang.Throwable)
     */
    public void trace(Object object, Throwable th) {
        if (isTraceEnabled()) {
            trace(object);
            printStackTrace(th);
        }
    }

    /* (overridden)
     * @see net.argius.logging.Logger#trace(java.lang.Object)
     */
    public void trace(Object object) {
        if (isTraceEnabled()) {
            printMessage("TRACE", object);
        }
    }

}