package net.argius.stew.gui;

import java.beans.*;
import java.io.*;

/**
 * j[ݒB
 * XMLEncoder/Decodergp邽߁APbeanɂȂĂB
 */
public final class MenuConfiguration implements Serializable {

    private static final long serialVersionUID = -9070962376007964266L;

    private static final String CLASS_NAME = MenuConfiguration.class.getName();
    private static final String FILE_NAME = CLASS_NAME + ".xml";

    private String columnAdjustMode;
    private int limitCount;

    /**
     * MenuConfiguration̐B
     */
    public MenuConfiguration() {
        this.columnAdjustMode = "NONE";
        this.limitCount = Menu.DEFAULT_LIMIT_COUNT;
    }

    /**
     * ݒ𕜌B
     * @param menu j[
     * @param directory ۑfBNg
     * @throws IOException o̓G[ꍇ
     */
    public static void load(Menu menu, File directory) throws IOException {
        File file = new File(directory, FILE_NAME);
        MenuConfiguration config;
        try {
            InputStream is = new FileInputStream(file);
            XMLDecoder decoder = new XMLDecoder(is);
            try {
                config = (MenuConfiguration)decoder.readObject();
            } finally {
                is.close();
            }
        } catch (FileNotFoundException ex) {
            config = new MenuConfiguration();
        }
        menu.setColumnAdjustMode(config.columnAdjustMode);
        menu.setLimitCount(config.limitCount);
    }

    /**
     * ݒۑB
     * @param menu EBhE
     * @param directory ۑfBNg
     * @throws IOException o̓G[ꍇ
     */
    public static void save(Menu menu, File directory) throws IOException {
        if (!directory.isDirectory()) {
            directory.mkdirs();
            if (!directory.isDirectory()) {
                throw new IOException("failed to save configuration");
            }
        }
        MenuConfiguration config = new MenuConfiguration();
        config.columnAdjustMode = menu.getColumnAdjustMode();
        config.limitCount = menu.getLimitCount();
        File file = new File(directory, FILE_NAME);
        XMLEncoder encoder = new XMLEncoder(new FileOutputStream(file));
        try {
            encoder.writeObject(config);
        } finally {
            encoder.close();
        }
    }

    /**
     * columnAdjustMode̎擾B
     * @return columnAdjustMode
     */
    public final String getColumnAdjustMode() {
        return columnAdjustMode;
    }

    /**
     * columnAdjustMode̐ݒB
     * @param columnAdjustMode columnAdjustMode
     */
    public final void setColumnAdjustMode(String columnAdjustMode) {
        this.columnAdjustMode = columnAdjustMode;
    }

    /**
     * limitCount̎擾B
     * @return limitCount
     */
    public final int getLimitCount() {
        return limitCount;
    }

    /**
     * limitCount̐ݒB
     * @param limitCount limitCount
     */
    public final void setLimitCount(int limitCount) {
        this.limitCount = limitCount;
    }

}
