package net.argius.stew.gui;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;
import java.sql.*;
import java.util.*;
import java.util.List;

import javax.swing.*;
import javax.swing.event.*;

import net.argius.stew.*;

/**
 * RlN^ҏW_CAOB
 */
final class ConnectorEditDialog extends FlexibleDialogBase {

    private static final int TEXT_SIZE = 32;

    private static File currentDirectory = new File(".");

    private final List lisnerList;
    private final JTextField tId;
    private final JTextField tName;
    private final JTextField tDriver;
    private final JTextField tClasspath;
    private final JTextField tUrl;
    private final JTextField tUser;
    private final JPasswordField tPassword;
    private final JComboBox cPasswordClass;
    private final JCheckBox cReadOnly;

    /**
     * ConnectorEditDialog̐B
     * @param owner Ăяo_CAO
     * @param connector RlN^
     */
    ConnectorEditDialog(JDialog owner, Connector connector) {
        super(owner);
        this.lisnerList = new LinkedList();

        // Form
        setTitle(getMessage("title"));
        initializeKeyBind(this);

        // Label & Text
        String id = connector.getId();
        tId = createJTextField(id);
        addComponent(new JLabel(getMessage("connector.id")), false);
        addComponent(tId, true);
        tName = createJTextField(connector.getName());
        addComponent(new JLabel(getMessage("connector.name")), false);
        addComponent(tName, true);
        tClasspath = createJTextField(connector.getClasspath());
        JButton bClasspath = createJButton(getMessage("button.search.file"),
                                           new ActionListener() {

                                               public void actionPerformed(ActionEvent e) {
                                                   onButtonClasspathClicked();
                                               }

                                           });
        addComponent(new JLabel(getMessage("connector.classpath")), false);
        addComponent(tClasspath, false);
        addComponent(bClasspath, true);
        tDriver = createJTextField(connector.getDriver());
        JButton bDriver = createJButton(getMessage("button.search.driver"),
                                        new ActionListener() {

                                            public void actionPerformed(ActionEvent e) {
                                                onButtonDriverClicked();
                                            }

                                        });
        addComponent(new JLabel(getMessage("connector.driver")), false);
        addComponent(tDriver, false);
        addComponent(bDriver, true);
        tUrl = createJTextField(connector.getUrl());
        addComponent(new JLabel(getMessage("connector.url")), false);
        addComponent(tUrl, true);
        tUser = createJTextField(connector.getUser());
        addComponent(new JLabel(getMessage("connector.user")), false);
        addComponent(tUser, true);
        tPassword = new JPasswordField(TEXT_SIZE);
        Password password = connector.getPassword();
        if (!StringClass.isBlank(id) && password.hasPassword()) {
            tPassword.setText(password.getRowString());
        }
        addComponent(new JLabel(getMessage("connector.password")), false);
        addComponent(tPassword, true);
        PasswordItem[] items = {new PasswordItem(PlainTextPassword.class),
                                new PasswordItem(PbePassword.class)};
        cPasswordClass = new JComboBox(items);
        cPasswordClass.setEditable(true);
        for (int i = 0; i < items.length; i++) {
            if (items[i].getPasswordClass() == password.getClass()) {
                cPasswordClass.setSelectedIndex(i);
                break;
            }
        }
        addComponent(new JLabel(getMessage("connector.encryption")), false);
        addComponent(cPasswordClass, true);
        cReadOnly = new JCheckBox(getMessage("connector.readonly"),
                                  connector.isReadOnly());
        addComponent(cReadOnly, true);

        // Button
        JPanel p = new JPanel(new GridLayout(1, 3, 16, 0));
        JButton buttonRegister = createJButton(getMessage("button.register"),
                                               new ActionListener() {

                                                   public void actionPerformed(ActionEvent e) {
                                                       onButtonSubmitClicked();
                                                   }

                                               });
        initializeKeyBind(buttonRegister);
        p.add(buttonRegister);
        JButton buttonTryConnect = createJButton(getMessage("button.try.connect"),
                                                 new ActionListener() {

                                                     public void actionPerformed(ActionEvent e) {
                                                         onButtonTryConnectClicked();
                                                     }

                                                 });
        initializeKeyBind(buttonTryConnect);
        p.add(buttonTryConnect);
        JButton buttonCancel = createJButton(getMessage("button.cancel"),
                                             new ActionListener() {

                                                 public void actionPerformed(ActionEvent e) {
                                                     onButtonCancelClicked();
                                                 }

                                             });
        initializeKeyBind(buttonCancel);
        p.add(buttonCancel);
        c.gridwidth = GridBagConstraints.REMAINDER;
        c.insets = new Insets(12, 0, 12, 0);
        c.anchor = GridBagConstraints.CENTER;
        addComponent(p, false);

        pack();
    }

    /**
     * JTextField̐B
     * @param value l
     * @return JTextField
     */
    private JTextField createJTextField(String value) {
        JTextField textField = new JTextField(TEXT_SIZE);
        if (value != null) {
            textField.setText(value);
            textField.setCaretPosition(0);
        }
        return textField;
    }

    /**
     * ύXXio^B
     * @param listener ύXXi
     */
    void addChangeListener(ChangeListener listener) {
        lisnerList.add(listener);
    }

    /**
     * ͒lRlN^𐶐B
     * @return RlN^
     */
    private Connector createConnector() {
        String id = tId.getText();
        Properties props = new Properties();
        props.setProperty("name", tName.getText());
        props.setProperty("driver", tDriver.getText());
        props.setProperty("classpath", tClasspath.getText());
        props.setProperty("url", tUrl.getText());
        props.setProperty("user", tUser.getText());
        props.setProperty("readonly", Boolean.toString(cReadOnly.isSelected()));
        Object item = cPasswordClass.getSelectedItem();
        if (item != null && item instanceof PasswordItem) {
            PasswordItem passwordItem = (PasswordItem)item;
            if (!passwordItem.getPasswordClass()
                             .equals(PlainTextPassword.class)) {
                props.setProperty("password.class", passwordItem.getName());
            }
        }
        Connector connector = new Connector(id, props);
        connector.getPassword()
                 .setRowString(String.valueOf(tPassword.getPassword()));
        return connector;
    }

    /**
     * NXpXt{^̏B
     */
    void onButtonClasspathClicked() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setCurrentDirectory(currentDirectory);
        fileChooser.setDialogTitle(getMessage("dialog.search.file.header"));
        fileChooser.setApproveButtonText(getMessage("dialog.search.file.button"));
        fileChooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
        fileChooser.showDialog(this, null);
        File file = fileChooser.getSelectedFile();
        if (file != null) {
            tClasspath.setText(file.getPath());
            currentDirectory = file.getParentFile();
        }
    }

    /**
     * hCot{^̏B
     */
    void onButtonDriverClicked() {
        String[] paths = tClasspath.getText().split(File.pathSeparator);
        URL[] urls = new URL[paths.length];
        for (int i = 0; i < urls.length; i++) {
            try {
                urls[i] = new File(paths[i]).toURL();
            } catch (MalformedURLException ex) {
                onError(ex);
            }
        }
        Class[] classes = DynamicLoader.getImplementedClasses(Driver.class,
                                                              urls);
        if (classes.length > 0) {
            String[] driverNames = new String[classes.length];
            for (int i = 0; i < driverNames.length; i++) {
                driverNames[i] = classes[i].getName();
            }
            String selected = (String)DialogMessage.select(this,
                                                           getMessage("dialog.search.driver.header"),
                                                           driverNames);
            if (selected != null) {
                tDriver.setText(selected);
                tDriver.setCaretPosition(0);
            }
        } else {
            DialogMessage.alert(this, getMessage("search.driver.classnotfound"));
        }
    }

    /**
     * ڑ{^̏B
     */
    void onButtonTryConnectClicked() {
        try {
            Connector connector = createConnector();
            Connection conn = connector.getConnection();
            try {
                DatabaseMetaData dbmeta = conn.getMetaData();
                Writer buffer = new StringWriter();
                PrintWriter out = new PrintWriter(buffer);
                out.println(getMessage("try.connect"));
                out.print(dbmeta.getDatabaseProductVersion());
                out.print(dbmeta.getDatabaseProductName());
                DialogMessage.notice(this, buffer.toString());
            } finally {
                conn.close();
            }
        } catch (SQLException ex) {
            Writer buffer = new StringWriter();
            PrintWriter out = new PrintWriter(buffer);
            out.println(ex.getMessage());
            while (true) {
                SQLException nextEx = ex.getNextException();
                if (nextEx != null && nextEx != ex) {
                    out.println(nextEx.getMessage());
                    ex = nextEx;
                    continue;
                }
                break;
            }
            DialogMessage.alert(this, buffer.toString());
        } catch (RuntimeException ex) {
            DialogMessage.alert(this, ex.toString());
        }
    }

    /**
     * "o^"{^ꂽ̏B
     */
    void onButtonSubmitClicked() {
        try {
            Connector connector = createConnector();
            ChangeEvent event = new ChangeEvent(connector);
            for (int i = 0, n = lisnerList.size(); i < n; i++) {
                ChangeListener listener = (ChangeListener)lisnerList.get(i);
                listener.stateChanged(event);
            }
            dispose();
        } catch (RuntimeException ex) {
            onError(ex);
        }
    }

    /**
     * "LZ"{^̏B
     */
    void onButtonCancelClicked() {
        dispose();
    }

    /**
     * (O)bZ[W̎擾B
     * @param key L[
     * @return bZ[W
     */
    private static String getMessage(String key) {
        return Messages.getString("dialog.ConnectorEditDialog." + key);
    }

    /**
     * pX[hځB
     */
    private static final class PasswordItem {

        final Class passwordClass;

        PasswordItem(Class passwordClass) {
            this.passwordClass = passwordClass;
        }

        Class getPasswordClass() {
            return passwordClass;
        }

        String getName() {
            return toString();
        }

        public String toString() {
            return passwordClass.getName();
        }

    }

}