package net.argius.stew.command;

import java.sql.*;

import net.argius.logging.*;
import net.argius.stew.*;

/**
 * SELECTR}hB
 */
public final class Select extends Command {

    private static final Logger log = LoggerFactory.getLogger(Select.class);

    /* (overridden)
     * @see net.argius.stew.Command#execute(java.sql.Connection, net.argius.stew.Parameter)
     */
    public void execute(Connection conn, Parameter parameter) throws CommandException {
        String sql = parameter.getAll();
        if (log.isDebugEnabled()) {
            log.debug("SQL : " + sql);
        }
        try {
            Statement stmt = conn.createStatement();
            try {
                setTimeout(stmt);
                ResultSet rs = stmt.executeQuery(sql);
                try {
                    ResultSetReference ref = new ResultSetReference(rs);
                    output(ref);
                    Object[] arguments = {new Integer(ref.getRecordCount())};
                    outputMessage(".selected", arguments);
                } finally {
                    rs.close();
                }
            } finally {
                stmt.close();
            }
        } catch (SQLException ex) {
            throw new CommandException(ex);
        }
    }

    /* (overridden)
     * @see net.argius.stew.Command#isReadOnly()
     */
    public boolean isReadOnly() {
        return true;
    }

}