package net.argius.stew.command;

import java.io.*;
import java.sql.*;

import net.argius.logging.*;
import net.argius.stew.*;
import net.argius.stew.io.*;

/**
 * t@C̓eSQLɔfR}hB
 * 
 * [h́ASQLt@CsƁAf[^[hAp[^ŋʂB
 * f[^[hł́At@C`͊gqɂ莩IɑIB
 * @see Importer
 */
public class Load extends Command {

    private static final Logger log = LoggerFactory.getLogger(Load.class);
    private static final String USAGE = getUsage("load");

    /* (overridden)
     * @see net.argius.stew.CommandInterface#execute(java.sql.Connection, net.argius.stew.Parameter)
     */
    public void execute(Connection conn, Parameter parameter) throws CommandException {
        if (parameter.isEmpty(2)) {
            throw new UsageException(USAGE);
        }
        // 
        int argsIndex = 2;
        String p1 = parameter.get(argsIndex++);
        if (log.isDebugEnabled()) {
            log.debug("file : " + p1);
        }
        try {
            // s
            File file = Path.resolve(env.getCurrentDirectory(), p1);
            if (parameter.isEmpty(3)) {
                loadSql(conn, file);
            } else {
                String p2 = parameter.get(argsIndex++);
                String p3 = parameter.get(argsIndex++);
                boolean hasHeader = p3.equalsIgnoreCase("header");
                loadRecord(conn, file, p2, hasHeader);
            }
        } catch (IOException ex) {
            throw new CommandException(ex);
        } catch (SQLException ex) {
            throw new CommandException(ex);
        }
    }

    /**
     * SQLt@CǂݍŎsB
     * @param conn RlNV
     * @param file SQLt@C
     * @throws IOException o̓G[ꍇ
     * @throws SQLException SQL֘AG[ꍇ
     */
    private void loadSql(Connection conn, File file) throws IOException, SQLException {
        StringBuffer buffer = new StringBuffer();
        char[] chars = new char[1024];
        FileReader reader = new FileReader(file);
        try {
            for (int length; (length = reader.read(chars)) >= 0;) {
                buffer.append(chars, 0, length);
            }
        } finally {
            reader.close();
        }
        String sql = buffer.toString();
        if (log.isDebugEnabled()) {
            log.debug("sql : " + sql);
        }
        Statement stmt = conn.createStatement();
        try {
            if (isSelect(sql)) {
                ResultSet rs = stmt.executeQuery(sql);
                try {
                    ResultSetReference ref = new ResultSetReference(rs);
                    output(ref);
                    Object[] arguments = {new Integer(ref.getRecordCount())};
                    outputMessage(".selected", arguments);
                } finally {
                    rs.close();
                }
            } else {
                int count = stmt.executeUpdate(sql);
                Object[] arguments = {new Integer(count)};
                outputMessage(".proceeded", arguments);
            }
        } finally {
            stmt.close();
        }
    }

    /**
     * R[ht@CǂݍłꂼInsertB
     * rŃG[ꍇAIRollbackȂB
     * @param conn RlNV
     * @param file R[ht@C
     * @param tableName e[u
     * @param hasHeader wb_ꍇ <code>true</code>
     * @throws IOException o̓G[ꍇ
     * @throws SQLException SQL֘AG[ꍇ
     */
    protected void loadRecord(Connection conn,
                              File file,
                              String tableName,
                              boolean hasHeader) throws IOException, SQLException {
        Importer importer = Importer.getImporter(file);
        try {
            // SQL
            StringBuffer buffer = new StringBuffer();
            buffer.append("INSERT INTO ");
            buffer.append(tableName);
            Object[] header;
            if (hasHeader) {
                buffer.append(" (");
                header = importer.nextRow();
                for (int i = 0; i < header.length; i++) {
                    if (i > 0) {
                        buffer.append(',');
                    }
                    buffer.append(header[i]);
                }
                buffer.append(')');
            } else {
                Importer importer2 = Importer.getImporter(file);
                try {
                    header = importer2.nextRow();
                } finally {
                    importer2.close();
                }
            }
            buffer.append(" VALUES (");
            for (int i = 0; i < header.length; i++) {
                if (i > 0) {
                    buffer.append(',');
                }
                buffer.append('?');
            }
            buffer.append(')');
            String sql = buffer.toString();
            if (log.isDebugEnabled()) {
                log.debug("SQL : " + sql);
            }
            PreparedStatement stmt = conn.prepareStatement(sql);
            try {
                insertRecords(stmt, importer);
            } finally {
                stmt.close();
            }
        } finally {
            importer.close();
        }
    }

    /**
     * R[hInsertB
     * @param stmt PreparedStatement
     * @param importer Importer
     * @throws IOException o̓G[ꍇ
     * @throws SQLException SQL֘AG[ꍇ
     */
    protected void insertRecords(PreparedStatement stmt, Importer importer) throws IOException, SQLException {
        int recordCount = 0;
        int insertedCount = 0;
        int errorCount = 0;
        while (true) {
            Object[] row = importer.nextRow();
            if (row == null || row.length == 0) {
                break;
            }
            ++recordCount;
            try {
                for (int i = 0; i < row.length; i++) {
                    int index = i + 1;
                    Object o = row[i];
                    stmt.setObject(index, o);
                }
                insertedCount += stmt.executeUpdate();
            } catch (SQLException ex) {
                String message = "error occurred at " + recordCount;
                if (log.isTraceEnabled()) {
                    log.trace(message, ex);
                } else if (log.isDebugEnabled()) {
                    log.debug(message + " : " + ex);
                }
                ++errorCount;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("record   = " + recordCount);
            log.debug("inserted = " + insertedCount);
            log.debug("error    = " + errorCount);
        }
        Object[] arguments = {new Integer(insertedCount),
                              new Integer(recordCount)};
        outputMessage(".loaded", arguments);
    }

}