/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.io;

public final class CsvFormatter {
    private static final int iRAW = 513;
    private static final int iSTRING = 1025;
    private static final int iESCAPE = 2049;
    private static final int iAUTO = 4097;
    public static final CsvFormatter RAW = new CsvFormatter(513);
    public static final CsvFormatter STRING = new CsvFormatter(1025);
    public static final CsvFormatter ESCAPE = new CsvFormatter(2049);
    public static final CsvFormatter AUTO = new CsvFormatter(4097);
    private final int form;

    private CsvFormatter(int n) {
        this.form = n;
    }

    public String format(String string) {
        switch (this.form) {
            case 513: {
                return string;
            }
            case 1025: {
                return this.editAsStringValue(string);
            }
            case 2049: {
                return this.editAsEscapeValue(string);
            }
            case 4097: {
                return this.editAuto(string);
            }
        }
        return string;
    }

    private String editAuto(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (string.indexOf(34) >= 0) {
            return this.editAsEscapeValue(string.replaceAll("\"", "\"\""));
        }
        if (string.indexOf(13) >= 0 || string.indexOf(10) >= 0) {
            return this.editAsEscapeValue(string);
        }
        String string2 = string.trim();
        if (string2.length() > 0) {
            if (string2.indexOf(44) >= 0) {
                return this.editAsEscapeValue(string);
            }
            char c = string2.charAt(0);
            if (c == '0' && string2.length() >= 2) {
                try {
                    Double.parseDouble(string);
                    return this.editAsStringValue(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (string2.indexOf(46) >= 0 && string2.charAt(string2.length() - 1) == '0') {
                try {
                    Double.parseDouble(string);
                    return this.editAsStringValue(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ('0' <= c && c <= '9') {
                try {
                    if (Long.parseLong(string2) > Integer.MAX_VALUE) {
                        return this.editAsStringValue(string);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    return this.editAsStringValue(string);
                }
            }
        }
        return string;
    }

    private String editAsStringValue(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("=\"");
        stringBuffer.append(CsvFormatter.escapeQuote(string));
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    private String editAsEscapeValue(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"');
        stringBuffer.append(CsvFormatter.escapeQuote(string));
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    private static String escapeQuote(String string) {
        return string.replaceAll("\"", "\"\"");
    }
}

