/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.gui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import net.argius.stew.gui.ContextMenu;
import net.argius.stew.gui.ResultSetTableRowNumberCellRenderer;

final class ResultSetTableRowHeader
extends JTable
implements PropertyChangeListener {
    private static final int DEFAULT_WIDTH = 40;
    private final JTable table;
    private final DefaultTableModel model;
    private final ContextMenu contextMenu;
    private int dragStartRow;

    public ResultSetTableRowHeader(JTable jTable) {
        this.table = jTable;
        this.model = new DefaultTableModel(0, 1){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.contextMenu = new ContextMenu(jTable);
        this.setModel(this.model);
        this.setFocusable(false);
        jTable.addPropertyChangeListener(this);
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        return ResultSetTableRowNumberCellRenderer.INSTANCE;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.table == null) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("enabled")) {
            boolean bl = this.table.isEnabled();
            this.setVisible(bl);
            if (bl) {
                this.setWidth();
                this.resetViewPosition();
            }
        } else if (string.equals("font")) {
            this.setFont(this.table.getFont());
        } else if (string.equals("rowHeight")) {
            this.setRowHeight(this.table.getRowHeight());
        }
    }

    private void setWidth() {
        int n = this.table.getRowCount();
        this.model.setRowCount(n);
        Dimension dimension = this.getSize();
        JLabel jLabel = new JLabel(String.valueOf((long)n * 1000L));
        dimension.width = jLabel.getPreferredSize().width > 40 ? jLabel.getPreferredSize().width : 40;
        this.setPreferredScrollableViewportSize(dimension);
    }

    private void resetViewPosition() {
        Container container = this.table.getParent();
        Container container2 = this.getParent();
        if (container instanceof JViewport && container2 instanceof JViewport) {
            JViewport jViewport = (JViewport)container;
            JViewport jViewport2 = (JViewport)container2;
            jViewport2.setViewPosition(jViewport.getViewPosition());
        }
    }

    void addRow(Object[] objectArray) {
        this.model.addRow(objectArray);
    }

    void removeRow(int n) {
        this.model.removeRow(n);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501) {
            this.changeTableRowSelection(mouseEvent);
            this.contextMenu.mouseClicked(mouseEvent);
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 506) {
            this.changeTableRowSelection(mouseEvent);
        }
    }

    void changeTableRowSelection(MouseEvent mouseEvent) {
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            boolean bl;
            int n = mouseEvent.getID();
            boolean bl2 = n == 501;
            boolean bl3 = bl = n == 506;
            if (bl2 || bl) {
                int n2;
                int n3;
                int n4;
                if (!mouseEvent.isControlDown() && !mouseEvent.isShiftDown()) {
                    this.table.clearSelection();
                }
                if ((n4 = this.rowAtPoint(point)) < 0 || this.getRowCount() < n4) {
                    return;
                }
                if (bl2) {
                    if (mouseEvent.isShiftDown()) {
                        n3 = this.dragStartRow;
                        n2 = n4;
                    } else {
                        this.dragStartRow = n4;
                        n3 = n4;
                        n2 = n4;
                    }
                } else if (bl) {
                    n3 = this.dragStartRow;
                    n2 = n4;
                } else {
                    return;
                }
                this.table.addRowSelectionInterval(n3, n2);
                this.table.addColumnSelectionInterval(this.table.getColumnCount() - 1, 0);
            }
        }
    }
}

